function glp = gl_fderc(alpha,xA,x0,kmax,menu)

%---
% evaluate the Grunwald--Letnikov fractional derivative
%---

  h = (x0-xA)/kmax;

  glp = 0.0;

  for k=-kmax:kmax

   x = x0+k*h;

   combA = gamma(alpha+1)/gamma(k+(alpha+3)/2)/gamma(-k+(alpha+1)/2);
   combB = gamma(alpha+1)/gamma(k+(alpha+1)/2)/gamma(-k+(alpha+3)/2);
   phiodd = 0.5*(combA-combB);

   phieven = gamma(alpha+1)/gamma(k+(alpha+2)/2) ...
                       /gamma(-k+(alpha+2)/2);

   phi = 0.5*(phieven+phiodd);
   phi = phiodd;
   phi = phieven;

   [f,fp,fpp,fppp] = fnc(x,menu);

   glp = glp + (-1)^k * phi *f;

  end

  glp = glp/h^alpha;

%---
% done
%---

return
