clear all
close all

eps = 0.01; % arbitrary

%====================================
% driver for the Grunwald--Letnikov
% fractional derivative
%====================================

menu = 5;  % Gaussian
menu = 4;  % exponential
menu = 20;  % flat

x = 1.0;  % arbitrary
xA = 0.0;  % arbitrary

alphamin = 0.01;
alphamax = 2.99;

nloop = 32;
nloop = 16;
nloop = 64;

dalpha = (alphamax-alphamin)/nloop;

%===
% plot
%===

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('\alpha','fontsize',15)
ylabel('f^{(\alpha)}','fontsize',15)
%axis([0 3 2.4 3.0])
box on

[f,fp,fpp,fppp] = fnc(x,menu);
plot([0.0],[f],'ro');
plot([1.0],[fp],'ro');
plot([2.0],[fpp],'ro');
plot([3.0],[fppp],'ro');

%=============

%------
% loop over kmax
%---

for kloop = 1:5

 if(kloop == 1) kmax = 16; end
 if(kloop == 2) kmax = 32; end
 if(kloop == 3) kmax = 64; end
 if(kloop == 4) kmax =128; end
 if(kloop == 5) kmax =256; end

%---
% loop over alpha
%---

for iloop = 1:nloop+1

 alpha = alphamin+(iloop-1)*dalpha;
 alphaplot(iloop) = alpha;

 glp = gl_fder(alpha,xA,x,kmax,menu);
 glplot(iloop) = glp;

 end

 if(kloop == 5)
  plot(alphaplot,glplot,'r');
 else
  plot(alphaplot,glplot,'k');
 end

end % of kloop
%=============

