function glp = gl_fder(alpha,xA,x,kmax,menu)

%===============================
% evaluate the Grunwald--Letnikov
% fractional derivative
%===============================

  h = (x-xA)/kmax;

  ishift = 1;

%---
% compute omegas
%---

  omg(ishift) = 1;

  for k=1:kmax
    omg(k+ishift) = omg(k-1+ishift)*(k-alpha-1)/k;
  end

%---
% sum
%---

  glp = 0.0;

  for k=0:kmax
   [f,fp,fpp,fppp] = fnc(x-k*h,menu);
   glp = glp + omg(k+ishift)*f;
  end
  glp = glp/h^alpha;

% sun = 0.0;
% for k=0:kmax
%  sun = sun + omg(k+ishift)*x^(k+ishift);
% end
% [sun, (1-x)^alpha]

%---
% done
%---

return
