clear all
close all

%==================================
% Evaluate the fractional laplacian
% in terms of Riemann--Liouville
% and the GL
% fractional derivatives
%================================

xA = -2.0;
xB =  2.0;

alpha = 0.123;
alpha = 0.89;

alpha = 0.678;
alpha = 1.5;

menu = 6;  % first moment of the Gaussian distribution
menu = 5;  % Gaussian distribution

%---
% prepare
%---

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('x','fontsize',15)
ylabel('f^{(\alpha)}','fontsize',15)
box on

%---
% for RL
%---

eps = 0.01;   % numerical differentiation step
nint = 2*32;  % intervals for numerical integration

%---
% for GL
%---

glkmax = 4*16;
glh = abs(xA)/glkmax;

glckmax = 4*32;

%---
% for GLcentered
%---

glkcmax = 4*16;
glh = abs(xA)/glkmax;

%============================================

for irepeat = 1:4

if(irepeat==1)
 x = 0.0;
elseif(irepeat==2)
 x = 0.5;
elseif(irepeat==3)
 x = 1.0;
elseif(irepeat==4)
 x = 1.5;
elseif(irepeat==5)
 x = 1.9;
end

%---
% evaluate and plot
%---

% rl:

rlder_left = rl_fder (alpha,xA,x,eps,nint,menu);
rlder_rite = rl_fderr(alpha,xB,x,eps,nint,menu);
rlflap =  rlder_left + rlder_rite;
rlflap = -rlflap /2/cos(alpha*pi/2);
[x, rlflap]
plot(x,rlflap,'ro')

% gl:

glflap = gl_flap (alpha,x,glh,glkmax,menu)
%plot(x,glflap,'r*')

% glc:

flaplc = gl_fderc(alpha,xA,x,glckmax,menu);
flaplc =-flaplc /2/cos(alpha*pi/2);
%plot(x,flaplc,'bo')

end

%===================================

%----
% exact for the gaussian
% and first moment of the gaussian
%----

if(menu==5)

 if(alpha == 1.5)
  [alphaga15, fraclapga15] = flga15;
  plot(alphaga15,fraclapga15,'k-')
 elseif(alpha == 0.678)
  [alphaga0678, fraclapga0678] = flga0678;
  plot(alphaga0678,fraclapga0678,'k-')
 end

elseif(menu==6)

 if(alpha == 1.5)
  [alphagm15, fraclapgm15] = flgm15;
  plot(alphagm15,fraclapgm15,'k-')
 elseif(alpha == 0.678)
  [alphagm0678, fraclapgm0678] = flgm0678;
  plot(alphagm0678,fraclapgm0678,'k-')
 end

end
