clear all
close all

%=======================
% driver for the right caputo
% fractional derivative
%=======================

x = 0.0;
xB = 1.0;

menu = 1;
menu = 6;
menu = 2;
menu = 3;
menu = 5;
menu = 4; % exponential

nint = 8*16;

%---
% prepare
%---

%---
% loop over alpha
%---

nloop = 64;
alphamax = 2.5;
alphamin = 0.01;
dalpha = (alphamax-alphamin)/nloop;

for iloop = 1:nloop

 alpha = alphamin+(iloop-1)*dalpha;

 if(alpha >= 0 & alpha < 1) n = 1; end
 if(alpha >= 1 & alpha < 2) n = 2; end
 if(alpha >= 2 & alpha < 3) n = 3; end

 cfder = caputo_fderr (alpha,xB,x,nint,menu);

 %---
 % compare with RL

  eps = 0.01;
  rlder = rl_fderr (alpha,xB,x,eps,nint,menu);

  [fB,fpB,fppB,fpppB] = fnc(xB,menu);

  if(n==1)
   cfder1 = rlder - fB/gamma(1-alpha) * (xB-x)^(0-alpha);
  elseif(n==2)
   cfder1 = rlder - fB/gamma(1-alpha)  * (xB-x)^(0-alpha) ...
                  + fpB/gamma(2-alpha) * (xB-x)^(1-alpha);
  elseif(n==3)
   cfder1 = rlder - fB/gamma(1-alpha)   * (xB-x)^(0-alpha) ...
                  + fpB/gamma(2-alpha)  * (xB-x)^(1-alpha) ...
                  - fppB/gamma(3-alpha) * (xB-x)^(2-alpha);
  else
   cfder1 = 0.0;
  end
  %---

 alphaplot(iloop) = alpha;
 cfderplot(iloop) = cfder;
 cfder1plot(iloop) = cfder1;
 rlipplot(iloop) = rlder;

end

%---
% plot
%---

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('\alpha','fontsize',15)
ylabel('D^{(\alpha)}f','fontsize',15)
box on

%plot(alphaplot(1:nloop/2),cfderplot(1:nloop/2),'k');
%plot(alphaplot(nloop/2+1:nloop),cfderplot(nloop/2+1:nloop),'k');
for i=1:nloop-1
 if(abs(cfderplot(i)-cfderplot(i+1)) < 0.7)
 plot([alphaplot(i), alphaplot(i+1)] ...
     ,[cfderplot(i), cfderplot(i+1)] ...
     ,'k-');
 end
end

%plot(alphaplot,cfder1plot,'r.');

plot(alphaplot,rlipplot,'k--');

[f,fp,fpp,fppp] = fnc(x,menu);

plot([0.0],[ f-fB],'ro');
plot([1.0],[-fp+fpB],'ro');
plot([2.0],[fpp-fppB],'ro');

plot([0.0],[f],'bo');
plot([1.0],[-fp],'bo');
plot([2.0],[fpp],'bo');

