function cfd = caputo_fderr (alpha,xB,x,nint,menu)

%========================================
% compute the Caputo fractional derivative
%
% (-1)^n int_x_xB f^(n)(x) /(xi-x)^(alpha+1-n) d xi
%
% nint: integration intervals
%========================================

%---
% prepare
%---

if(alpha >= 0 & alpha < 1)
  n = 1;
elseif(alpha >= 1 & alpha < 2)
  n = 2;
elseif(alpha >= 2 & alpha < 3)
  n = 3;
else
  disp('caputo_fderr: this values of alpha not yet available')
  return
end

Dx = (xB-x)/nint;
nexp = alpha+1-n;

[f,fp,fpp,fppp] = fnc(x,menu);

%---
% integrate by the mid-point rule
%---

intgrl = 0.0;

for i=1:nint

 xi(i) = x + (i-0.5)*Dx;
 xr(i) = xi(i)-x;

 [fxi(i),fxip(i),fxipp(i),fxippp(i)]  ...
        = fnc(xi(i),menu);

 if(n==1)
  intgrl = intgrl + (fxip(i)-fp)/xr(i)^nexp;
 elseif(n==2)
  intgrl = intgrl + (fxipp(i)-fpp)/xr(i)^nexp;
 elseif(n==3)
  intgrl = intgrl + (fxippp(i)-fppp)/xr(i)^nexp;
 end

end
%---

cfd = intgrl*Dx;

nal = n-alpha;

 if(n==1)
  cfd = cfd + fp/nal * (xB-x)^nal;
 elseif(n==2)
  cfd = cfd + fpp/nal * (xB-x)^nal;
 elseif(n==3)
  cfd = cfd + fppp/nal * (xB-x)^nal;
 end

cfd = (-1)^n*cfd/gamma(nal);

%---
% done
%---

return
