clear all
close all

%=======================
% driver for the caputo
% fractional derivative
%=======================

xA = 0.0;

x = 1.0;

menu = 2;
menu = 6;
menu = 3;  % power
menu = 5;  % Gaussian
menu = 4;  % exponential

%---
% prepare
%---

nint = 8*16;

%---
% loop over alpha
%---

alphamin = 0.01;
alphamax = 2.50;

nloop = 2*64;
dalpha = (alphamax-alphamin)/nloop;

for iloop = 1:nloop

 alpha = alphamin + (iloop-1)*dalpha;

 if(alpha >= 0 & alpha < 1) n = 1; end
 if(alpha >= 1 & alpha < 2) n = 2; end
 if(alpha >= 2 & alpha < 3) n = 3; end

 cfder = caputo_fder (alpha,xA,x,nint,menu);

 %---
 % compare with RL
 % and reconcile
 %---

  eps = 0.01;
  rlder = rl_fder (alpha,xA,x,eps,nint,menu);

  [fA,fpA,fppA,fpppA] = fnc(xA,menu);

  if(n==1)
   cfder1 = rlder - fA/gamma(1-alpha)  * (x-xA)^(0-alpha);
  elseif(n==2)
   cfder1 = rlder - fA/gamma(1-alpha)  * (x-xA)^(0-alpha) ...
                  - fpA/gamma(2-alpha) * (x-xA)^(1-alpha);
  elseif(n==3)
   cfder1 = rlder - fA/gamma(1-alpha)  * (x-xA)^(0-alpha) ...
                  - fpA/gamma(2-alpha) * (x-xA)^(1-alpha) ...
                  - fppA/gamma(3-alpha)* (x-xA)^(2-alpha);
  else
   cfder1 = 0.0;
  end


  %---
  % end of comparison
  %---

  alphaplot(iloop) = alpha;
  cfderplot(iloop) = cfder;
   rlipplot(iloop) = rlder;
 cfder1plot(iloop) = cfder1;

  if(menu==3)
   p =1.567;
   exact(iloop) = gamma(p+1)/gamma(p-alpha+1) * (x-xA)^(p-alpha);
  end

end

%---
% plot
%---

figure(1)
hold on
set(gca,'fontsize',15)
xlabel('\alpha','fontsize',15)
ylabel('D^{(\alpha)}f','fontsize',15)
box on


%plot(alphaplot(1:nloop/2),cfderplot(1:nloop/2),'k');
%plot(alphaplot(nloop/2+1:nloop),cfderplot(nloop/2+1:nloop),'k');
for i=1:nloop-1
 if(abs(cfderplot(i)-cfderplot(i+1)) < 0.7)
 plot([alphaplot(i), alphaplot(i+1)] ...
     ,[cfderplot(i), cfderplot(i+1)] ...
     ,'k-');
 end
end

if(menu==3)
% plot(alphaplot,exact,'cs--');
end

%plot(alphaplot,cfderplot,'c.');
plot(alphaplot,rlipplot,'k--');
%plot(alphaplot,cfder1plot,'r.');

%---
% pointwise
%---

[f,fp,fpp,fppp] = fnc(x,menu);

plot([0.0],[f-fA],'ro');
plot([1.0],[fp-fpA],'ro');
plot([2.0],[fpp-fppA],'ro');
plot([0.0],[f],'bo');
plot([1.0],[fp],'bo');
plot([2.0],[fpp],'bo');
