close all
clear all

%==========================================
% FDLIB
%
% Copyright by C. Pozrikidis, 1999
% All rights reserved.
%
% This program is to be used only under the
% stipulations of the licensing agreement
%==========================================

%===========================================
% Prepare a plot of the fractional laplacian
%===========================================

%---
% choose the function
%---

ifun = 2;  % first moment of the Gaussian
ifun = 1;  % Gaussian distribution

ibrink = 1;
ibrink = 0;

%---
% paraments
%---

Nint = 2^6;  % number of integration points

xmin = 0.0; 
xmax = 3.0; 

Nx = 2*32;

%---
% prepare
%---

xspan = xmax-xmin;

Dx = xspan/Nx;

%=======
%for loopa=1:6
for loopa=2:2
%=======

  if(loopa==1)
  alpha = 1.90;
  elseif(loopa==2)
  alpha = 1.50;
  elseif(loopa==3)
  alpha = 1.001;
  elseif(loopa==4)
  alpha = 0.50;
  elseif(loopa==5)
  alpha = 0.10;
  elseif(loopa==6)
  alpha = 0.0001;
  end

  alp = 1.0+alpha;
  alpp = 2.0-alpha;

%===================
for ix=1:Nx+1
%=====================

 x = xmin+(ix-1.0)*Dx;

%---
% integration limits
%---

  a = 0.00001;
  b = x + 9.0000;

  Dv = (b-a)/Nint;

%---
% base points and function values
%---

 for i=1:Nint+1

  v = a+(i-1.0)*Dv;


  if(ifun==1)
   f(i) =     (    exp(-(x-v)^2) ...
              -2.0*exp(-    x^2) ...
              +    exp(-(x+v)^2) ...
              +2.0*(1.0-2.0*x^2)*exp(-x^2)*v^2 )/v^alp;
  elseif(ifun==2)
   f(i) =     (    (x-v)*exp(-(x-v)^2) ...
              -2.0*x    *exp(-    x^2) ...
              +    (x+v)*exp(-(x+v)^2) ...
              +2.0*x*(3.0-2.0*x^2)*exp(-x^2)*v^2 )/v^alp;
  end

  vplot(i) = v;

 end

figure(3)
plot(vplot,f)

%---
% display
%---

%figure(1)
%hold on;
%axis off

%---
% compute the v integral
% by the trapezoidal rule
%---

 trapz = 0.5*f(1);

 for i=2:Nint
    trapz = trapz + f(i);
 end

 trapz = trapz + 0.5*f(Nint+1);
 trapz = trapz*Dv;

 if(ifun==1)
  trapz = trapz + 2.0*(2.0*x^2-1.0)*exp(-x^2)*(b^alpp+0^alpp)/alpp;
  trapz = trapz - 2.0*exp(-x^2)/(alpha*b^alpha);
 elseif(ifun==2)
  trapz = trapz + 2.0*x*(2.0*x^2-3.0)*exp(-x^2)*(b^alpp+0^alpp)/alpp;
  trapz = trapz - 2.0*x*exp(-x^2)/(alpha*b^alpha);
 end

 c1 = 0.5*alpha/(gamma(1-alpha)*cos(alpha*pi/2));

  trapz = c1*trapz;

     xplot(ix) =  x;
   fraclap(ix) = trapz;

 if(ifun==1)
   fnc(ix) = exp(-x^2);
   der2(ix) = 2.0*(2.0*x^2-1)*exp(-x^2);
   mterms = 40;
   exact(ix) = - 1/sqrt(pi) * 2^alpha * gamma((1+alpha)/2) ...
       * hypergeometric_Phi(mterms, (1+alpha)/2, 1/2, -x^2);
 elseif(ifun==2)
   fnc(ix) = x*exp(-x^2);
   der2(ix)  =  2.0*x*(2.0*x^2-3.0)*exp(-x^2);
 end

 fraclap_brink(ix) = -(1-alpha/2)*fnc(ix) ...
                        + alpha/2*der2(ix);

 if(ix==1) 
  if(ifun==1)
%  fraclap(ix)
%  exact_0 = -2^alpha*gamma((1+alpha)/2)/sqrt(pi)
%  pause
  end
 end

%-----------
end % of ix
%-----------

 figure(30)
 hold on
 set(gca,'fontsize',15)
 box on

 if(ifun==1)
  exact_0 = -2^alpha*gamma((1+alpha)/2)/sqrt(pi);
  plot(0,exact_0,'ko')
 end

 plot(xplot, der2,'r-','linewidth',3)
 plot(xplot,-fnc,'k--','linewidth',3)

 %---
 if(ibrink==0)
  plot(xplot,fraclap,'k','linewidth',1)
% plot(xplot,exact,'r--','linewidth',1)
 else
  plot(xplot,fraclap_brink,'k-','linewidth',1)
 end
 %---

%---
% reflect
%---

 if(ifun==1)
  if(ibrink==0)
   plot(-xplot,fraclap,'k','linewidth',1)
%  plot(-xplot,exact,'r--','linewidth',1)
  else
   plot(-xplot,fraclap_brink,'k-','linewidth',1)
  end
  plot(-xplot, der2,'r-','linewidth',3)
  plot(-xplot,-fnc,'k--','linewidth',3)

 elseif(ifun==2)

  if(ibrink==0)
   plot(-xplot,-fraclap,'k','linewidth',1)
  else
   plot(-xplot,-fraclap_brink,'k-','linewidth',1)
  end
  plot(-xplot,-der2,'r-','linewidth',3)
  plot(-xplot, fnc,'k--','linewidth',3)

 end

 xlabel('x','fontsize',15)

 if(ifun==1)
%  ylabel('-(-\Delta)^\alpha^/^2 exp(-x^2)','fontsize',15)
%  ylabel('\nabla^\alpha exp(-x^2)','fontsize',15)
   ylabel('f\prime\prime','fontsize',15)
   axis([-3 3 -2.2 1])
 elseif(ifun==2)
%  ylabel('-(-\Delta)^\alpha^/^2 x exp(-x^2)','fontsize',15)
%  ylabel('\nabla^\alpha x exp(-x^2)','fontsize',15)
   ylabel('f\prime\prime','fontsize',15)
   axis([-3 3 -2.2 2.2])
 end

for i=2:Nx-1
 fracder3(i) = (fraclap(i+1)-fraclap(i-1))/(2.0*Dx);
 fracder4(i) = (fraclap(i-1)-2*fraclap(i)+fraclap(i+1))/Dx^2;
end

figure(88)
hold on
plot( xplot(2:Nx-2), fracder3(2:Nx-2),'k-')
if(ifun==1)
 plot(-xplot(2:Nx-2),-fracder3(2:Nx-2),'k-')
elseif(ifun==2)
 plot(-xplot(2:Nx-2), fracder3(2:Nx-2),'k-')
end

figure(89)
hold on
plot( xplot(2:Nx-2), fracder4(2:Nx-2),'k-')
if(ifun==1)
 plot(-xplot(2:Nx-2), fracder4(2:Nx-2),'k-')
elseif(ifun==2)
 plot(-xplot(2:Nx-2),-fracder4(2:Nx-2),'k-')
end

%===
end % of loopa
%===
