clear all
close all

%=============================
% Flow in a rectangular channel
% inside -a<y<a and -b<z<b
% with the slip boundary condition
%=============================

a = 1.0;
b = 0.5;

Ny = 2*16;
Nz = 2*16;



slipl=0.01;
slipl=0.001;
slipl=0.3;
slipl=0.2;
slipl=0.4;
slipl=1.0;
slipl=0.75;
slipl=0.5;
slipl=0.1;

pg = 1.0; % effective pressure gradient (chi)

%---
% prepare
%---

Dy = 2.0*a/Ny;
Dz = 2.0*b/Nz;

Dys = Dy*Dy;

beta = Dy^2/Dz^2;

%---
% grid
%---

for i=1:Ny+1
 x(i) = -a + (i-1)*Dy;
end

for i=1:Nz+1
 y(i) = -b + (i-1)*Dz;
end

%---
% tridiagonal in y involving slip
%---

slp = 2.0*Dy/slipl;

U(1,1) = -2-slp;
U(1,2) = 2;
U(Ny+1,Nz+1) =-2-slp;
U(Ny+1,Nz)   = 2;

for i=2:Ny
 U(i,i)   =-2;
 U(i,i-1) = 1;
 U(i,i+1) = 1;
end

%---
% tridiagonal in z involving slip
%---

slp = 2.0*Dz/slipl;

V(1,1) = -2-slp;
V(1,2) =  2;
V(Nz+1,Nz+1) =-2-slp;
V(Nz+1,Nz)   = 2;

for i=2:Nz
 V(i,i) = -2;
 V(i,i-1) = 1;
 V(i,i+1) = 1;
end

%---
% coefficient matrix
%---

A = kron(eye(Nz+1),U) + beta*kron(V,eye(Ny+1));
%A

%---
% system size
%---

Nsys = (Ny+1)*(Nz+1);

%---
% right-hand side
%---

for i=1:Nsys
 rhs(i) = -pg*Dys;
end

%---
% solve
%---

SOL = rhs/A';

%---
% distribute
%---

Ic = 0;

for j=1:Nz+1
 for i=1:Ny+1
  Ic = Ic+1;
  f(i,j) = SOL(Ic);
 end
end

%---
% plot
%---

figure(1)
surf(x,y,5.0*f')
box on
axis equal
xlabel('y/a','fontsize',15)
ylabel('z/a','fontsize',15)
zlabel('5*u','fontsize',15)
set(gca,'fontsize',15)
view(-33, 22)

%---
% flow rate
%---

flow_rate = 0.0;

for j=1:Nz
 for i=1:Ny
  flow_rate = flow_rate + 0.25*(f(i,j)+f(i+1,j) ...
             +f(i+1,j+1)+f(i,j+1) );
 end
end

flow_rate = flow_rate*Dy*Dz;
flow_rate

%---
% exact flow rate for no slip
%---

maxsm = 20;

sm = 0.0;
aob=a/b;

for n=1:maxsm
    alpha = (n-0.5)*pi;
    sm = sm + tanh(alpha*aob)/alpha^5;
end

F = 1.0-6.0*sm/aob;
flow_rate_exact_no_slip = 4*pg*a*b^3*F/3.0;

scaled_flow_rate = flow_rate/flow_rate_exact_no_slip;

scaled_flow_rate
