clear all
close all

% b/a=1

a = 1;
b = 1;

flow_rate_100= [ 0.0 1.0;
                 0.10 1.3885;
                 0.20 1.7685;
                 0.30 2.1417;
                 0.40 2.5107;
                 0.50 2.8768;
                 0.75 3.7842;
                 1.00 4.6853
               ];

flow_rate_100(:,1)=flow_rate_100(:,1)/b;

% b/a=0.75

a = 1;
b = 0.75;

flow_rate_075= [ 0.0 1.0;
                 0.20 1.9112;
                 0.50 3.2238;
                 0.75 4.2993;
               ];

flow_rate_075(:,1)=flow_rate_075(:,1)/b;


% b/a=0.5

a = 1;
b = 0.5;

flow_rate_050= [ 0.0 1.0;
                 0.10 1.6367;
                 0.30 2.8677;
                 0.40 3.4714;
                 0.50 4.0707;
               ];

flow_rate_050(:,1)=flow_rate_050(:,1)/b;

% b/a=0.2

a = 1;
b = 0.2;

flow_rate_020= [ 0.0 1.0;
                 0.20 4.0018;
               ];

flow_rate_020(:,1)=flow_rate_020(:,1)/b;

%---
% asymptotic
%---

boa = 1.0;
nplot = 32;
Dlam = 0.5/nplot;

for i=1:nplot+1
 lam = (i-1)*Dlam;
 Phi = 1.0+2.0*lam;
 a1 = pi/2*(1.0-lam);
 den = cosh(a1/boa) + lam*a1*sinh(a1/boa);
 F(i) = 1+3*lam -48/pi^3*Phi*boa*sinh(a1/boa)*sin(a1)/(a1^2*den);
 plotlam(i) = lam;
end

red = F(1);
for i=1:nplot+1
 F(i) = F(i)/red;
end


figure(1)
box on
hold on
plot(flow_rate_100(:,1),flow_rate_100(:,2),'k-o');
plot(flow_rate_075(:,1),flow_rate_075(:,2),'k-*');
plot(flow_rate_050(:,1),flow_rate_050(:,2),'k-s');
plot(flow_rate_020(:,1),flow_rate_020(:,2),'kd');
plot([0, 1.0],[1,5],'--b')   % circle
plot([0, 1.0],[1,4],'--r')  % channel

%plot(plotlam,F,'b-')
xlabel('\lambda','fontsize',15)
ylabel('Q/Q_0','fontsize',15)
set(gca,'fontsize',15)
axis([0 1 1 5])


% analytical solution for b/a = 1

analytical=[
        0    1.0000
    0.0500    1.1993
    0.1000    1.3943
    0.1500    1.5863
    0.2000    1.7761
    0.2500    1.9642
    0.3000    2.1510
    0.3500    2.3368
    0.4000    2.5217
    0.4500    2.7060
    0.5000    2.8897
    0.5500    3.0729
    0.6000    3.2557
    0.6500    3.4381
    0.7000    3.6202
    0.7500    3.8020
    0.8000    3.9836
    0.8500    4.1649
    0.9000    4.3461
    0.9500    4.5271
    1.0000    4.7080
    1.0500    4.8887
    1.1000    5.0693
    1.1500    5.2497
    1.2000    5.4301
    1.2500    5.6104
    1.3000    5.7906
    1.3500    5.9707
    1.4000    6.1507
    1.4500    6.3307
    1.5000    6.5106
    1.5500    6.6904];

figure(2)
box on
hold on
plot(flow_rate_100(:,1),flow_rate_100(:,2),'k-o');
plot(analytical(:,1),analytical(:,2),'r*');

%plot(plotlam,F,'b-')
xlabel('\lambda','fontsize',15)
ylabel('Q/Q_0','fontsize',15)
set(gca,'fontsize',15)
axis([0 1 1 5])

