clear all
close all

%==================
% Graph Laplacian matrix
% of the twisted toroidal
% square network
%
% nodes run VERTICALLY and then
% HORIZONTALLY
%==================

N1 = 8;
N2 = 8;

N1 = 4;
N2 = 4;

N1 = 3;
N2 = 3;

%---
% number of twists
%---

m = N2

m = 3;
m = 0;
m = 1;
m = 2;

%-----------
% initialize
%-----------

for i=1:N1
 for j=1:N2
  Lap(i,j) = 0;
 end
end

%---------------------------------
% r(i,j): location of the i,j node
% in the solution vector
%
% nodes run VERTICALLY and then
% HORIZONTALLY
%---------------------------------

Ic = 0;

for i=1:N1
 for j=1:N2
  Ic = Ic+1;
  r(i,j) = Ic;
  Lap(Ic,Ic) = 4;
 end
end

%---
% fill in the Laplacian matrix
%---

for i=1:N1
 for j=1:N2

   rnod = r(i,j);

   if(i==1)     % left link
    rlef = r(N1,j);
   else
    rlef = r(i-1,j);
   end

   if(i==N1)     % right link
    rrit = r(1,j);
   else
    rrit = r(i+1,j);
   end

   if(j==1) % bottom
    ibot = i+m;
    if(ibot>N1) ibot = ibot-N1; end
    if(ibot<1)  ibot = ibot+N1; end
    rbot = r(ibot,N2);
   else
    rbot = r(i,j-1);
   end

   if(j==N2) % top
    itop = i-m;
    if(itop<1)  itop = itop+N2; end
    if(itop>N1) itop = itop-N2; end
    rtop = r(itop,1);
   else
    rtop = r(i,j+1);
   end

   Lap(rnod,rlef) = -1;
   Lap(rnod,rrit) = -1;
   Lap(rnod,rbot) = -1;
   Lap(rnod,rtop) = -1;
 end
end

Lap
eig(Lap)

