clear all
close all

%==================
% Graph Laplacian matrix
% of the twisted toroidal
% square network
%
% nodes run horizontally
% and then vertically
%==================

N1 = 8;
N2 = 8;

N1 = 4;
N2 = 4;

N1 = 3;
N2 = 3;

%---
% number of twists
%---

m = N2

m = 3;
m = 0;
m = 1;
m = 2;

%-----------
% initialize
%-----------

for j=1:N2
 for i=1:N1
  Lap(i,j) = 0;
 end
end

%---------------------------------
% r(i,j): location of the i,j node
% in the solution vector
%
% nodes run horizontally and then
% vertically
%---------------------------------

Ic = 0;

for j=1:N2
 for i=1:N1
  Ic = Ic+1;
  r(i,j) = Ic;
  Lap(Ic,Ic) = 4;
 end
end

%---
% fill in the Laplacian matrix
%---

for j=1:N2
 for i=1:N1

   rnod = r(i,j);

   if(i==1)  % left link
    jlef = j+m;
    if(jlef>N2) jlef = jlef-N2; end
    if(jlef<1)  jlef = jlef+N2; end
    rlef = r(N1,jlef);
   else
    rlef = r(i-1,j);
   end

   if(i==N1) % right
    jrit = j-m;
    if(jrit<1)  jrit = jrit+N2; end
    if(jrit>N2) jrit = jrit-N2; end
    rrit = r(1,jrit);
   else
    rrit = r(i+1,j);
   end

   if(j==1) % bottom
    rbot = r(i,N2);
   else
    rbot = r(i,j-1);
   end

   if(j==N2) % top
    rtop = r(i,1);
   else
    rtop = r(i,j+1);
   end

   Lap(rnod,rlef) = -1;
   Lap(rnod,rrit) = -1;
   Lap(rnod,rbot) = -1;
   Lap(rnod,rtop) = -1;
 end
end

Lap
eig(Lap)

%===============================
% Laplacian with tensor products
%
% wrong and incomplete
%===============================

%---
% initialize
%---

for i=1:N1
 for j=1:N1
  U(i,j) = 0.0;
  J(i,j) = 0.0;
 end
end

for i=1:N2
 for j=1:N2
  V(i,j) = 0.0;
 end
end

%---
% initialize
%---

for i=1:N2
 for j=1:N2
  K(i,j) = 0.0;
 end
end

%---
% periodic in the first direction
%---

U(1,1) = 2; U(1,2) = -1;% U(1,N1) = -1;
%U(N1,1) = -1;
U(N1,N1-1) = -1; U(N1,N1) = 2;

for i=2:N1-1
 U(i,i) = 2;
 U(i,i-1) = -1;
 U(i,i+1) = -1;
end

%---
% periodic in the second direction
%---

V(1,1) = 2; V(1,2) = -1; V(1,N2) = -1;
V(N2,1) = -1; V(N2,N2-1) = -1; V(N2,N2) = 2;

for i=2:N2-1
 V(i,i) = 2;
 V(i,i-1) = -1;
 V(i,i+1) = -1;
end

%---
% matrix J
%---

J(1,N1) = 1.0;
J(N1,1) = 1.0;

%---
% Laplacian
%---

if(m==1)
 K = eye(N2);
elseif(m==2)
 K = [ 0 1 0;
       0 0 1;
       1 0 0];
end

% exact for m=1:

%Lapl = kron(eye(N2),U) - kron(eye(N2),J) + kron(V,eye(N1))

% ad hoc
Lapl = kron(eye(N2),U) + kron(V,eye(N1));
Lapl
Lap-Lapl

