clear all
close all

%---
% draw a square network
% on a twisted torus torus
%---

N1 = 2*8;
N2 = 8;

a1 = 1.0;
a2 = 1.0;

mtwist = N2;  % offset of angle theta (arbitrary integer)
mtwist = 0;   % offset of angle theta (arbitrary integer)
mtwist = 1;   % offset of angle theta (arbitrary integer)
mtwist = 2;   % offset of angle theta (arbitrary integer)

%---
% ring and cross-sectional radius
%---

rrad = N1*a1/(2.0*pi);
crad = N2*a2/(2.0*pi);

dthet = 2*pi/N2;

dang = 2*pi/N1;

%---
% run along the torus
%---

for i=1:N1+1

 ang = (i-1)*dang;
 cang = cos(ang);
 sang = sin(ang);

 thetoff = mtwist*2*pi/N2 * (i-1)/N1 + 0.5*pi;

 % run around the torus

 for j=1:N2+1
  thet = (j-1.0)*dthet+thetoff;
  pcrx = 0.0;
  pcry = 2*rrad + crad*cos(thet);
  pcrz =          crad*sin(thet);
  px(i,j) = cang*pcrx + sang*pcry;
  py(i,j) =-sang*pcrx + cang*pcry;
  pz(i,j) = pcrz;
  pc(i,j) = pz(j);
 end

end

%---
% graphics
%---

 figure(1)
 hold on
 axis equal
 fc = 0.2;
 fcz = 0.5;
% axis([-fc*L,fc*L,-fc*L,fc*L,-fcz*W,fcz*W])
 mesh(px,py,pz)
% surf(px,py,pz)
% for j=1:N2
%  plot3(px(:,j),py(:,j),pz(:,j));
% end
 xlabel('x','fontsize',15)
 ylabel('y','fontsize',15)
 zlabel('z','fontsize',15)
 set(gca,'fontsize',15)
 view(95,75)
 view(90,90)
 axis off
