clear all
close all

%==================
% Laplacian matrix
%==================

N1 = 3;
N2 = 4;

%-----------
% initialize
%-----------

for j=1:N2
 for i=1:N1
  Lap(i,j) = 0;
 end
end

%---
% r(i,j): location of the i,j node
% in the solution vector
%---

Ic = 0;

for j=1:N2
 for i=1:N1
  Ic = Ic+1;
  r(i,j) = Ic;
  Lap(Ic,Ic) = 4;
 end
end

%---
% fill in the Laplacian matrix
%---

for j=1:N2
 for i=1:N1

   rnod = r(i,j);

   if(i==1)        % left
    rlef = r(N1,j);
   else
    rlef = r(i-1,j);
   end

   if(i==N1)        % right
    rrit = r(1,j);
   else
    rrit = r(i+1,j);
   end

   if(j==1) % bottom
    rbot = r(i,N2);
   else
    rbot = r(i,j-1);
   end

   if(j==N2) % top
    rtop = r(i,1);
   else
    rtop = r(i,j+1);
   end

   Lap(rnod,rlef) = -1;
   Lap(rnod,rrit) = -1;
   Lap(rnod,rbot) = -1;
   Lap(rnod,rtop) = -1;

 end
end

Lap

%===================
% Laplacian in terms
% of tensor products
%===================

%---
% periodic in x
%---

U(1,1) = 2; U(1,2) = -1; U(1,N1) = -1;
U(N1,1) = -1; U(N1,N1-1) = -1; U(N1,N1) = 2;

for i=2:N1-1
 U(i,i) = 2;
 U(i,i-1) = -1;
 U(i,i+1) = -1;
end

%---
% periodic in y
%---

V(1,1) = 2; V(1,2) = -1; V(1,N2) = -1;
V(N2,1) = -1; V(N2,N2-1) = -1; V(N2,N2) = 2;

for i=2:N2-1
 V(i,i) = 2;
 V(i,i-1) = -1;
 V(i,i+1) = -1;
end

Lapl = kron(eye(N2),U) + kron(V,eye(N1));
Lapl
