clear all
close all

%========================
% Mobius strip periodic
% in the first direction
%
% a1: link size in the first direction
% a2: link size in the second direction
%========================

N1 = 4*4;
N2 = 2*4;

a1  = 2.0;
a2  = 1.0;

ntwist = 1;
ntwist = 2;

%---
% prepare
%---

L = N1*a1;
W = N2*a2;

%---
% total number of nodes
%---

N = N1*(N2+1);

%---
% nodes in a planar rectangular strip
%
% -0.5*L < x < 0.5*L
% -0.5*W < y < 0.5*W
%---

for j=1:N2+1
 for i=1:N1+1
  p1(i,j) = -0.5*L+(i-1)*a1;
  p2(i,j) = -0.5*W+(j-1)*a2;
 end
end

%===========================
% twist around the first axis
%===========================

 angoff = 0.5*pi;
 angoff = 0.1245*pi; % arbitrary
 angoff = 0.0*pi;

 for i=1:N1+1
% ang = pi*p1(i,1)/L;
  ang = pi*(i-1)/N1-angoff;
  ang = ntwist*ang;
  for j=1:N2+1
   pp1(i,j) = p1(i,j);
   pp2(i,j) = p2(i,j)*cos(ang);
   pp3(i,j) = p2(i,j)*sin(ang);
   ppc(i,j) = p2(i,j); % color
  end
 end

%---
% plot
%---

 figure(1)
 hold on
 axis equal
 axis([-0.55*L,0.55*L,-0.55*W,0.55*W,-0.55*W,0.55*W])
 axis off
 mesh(pp1,pp2,pp3,ppc)
%surf(pp1,pp2,pp3,ppc)
 view(136,16)
