clear all
close all

%========================
% Mobius strip
% by direct construction
%
% a1: link size in the first direction
% a2: link size in the second direction
%========================

N1 = 8*4;
N2 = 2*4;

a1  = 2.0;
a2  = 1.0;

ntwists = 1;

angoff = 0.78615*pi;  % arbitrary
phioff = 0.27834*pi;  % arbitrary

%---
% prepare
%---

L = N1*a1;
W = N2*a2;

radius = L/(2.0*pi);

%---
% nodes in a planar rectangular strip
%
% -0.5*L < x < 0.5*L
% -0.5*W < y < 0.5*W
%---

for j=1:N2+1
 for i=1:N1+1
  p1(i,j) = -0.5*L+(i-1)*a1;
  p2(i,j) = -0.5*W+(j-1)*a2;
 end
end

%---
% run along the strip
%---

 for i=1:N1+1

%--------------------------------
% bend the strip around the second axis
% to form a ring of radius L/2pi
% around the second axis
%--------------------------------

  ang = 2*pi*(i-1)/N1-angoff;
  sang = sin(ang);
  cang = cos(ang);

  % centerline is a circle in the 31 plane

  pcl1(i) =  radius*cang; % centerline
  pcl2(i) =  0.0;         % centerline
  pcl3(i) =  radius*sang; % centerline

  % bend into a cylindrical strip

  for j=1:N2+1
   pp1(i,j) = radius*cang;
   pp2(i,j) = p2(i,j);
   pp3(i,j) = radius*sang;
   ppc(i,j) = p2(i,j); % color
  end

%---
% twist around the centerline
%---

  A = sang;
  B = 0.0;
  C =-cang;

  phi = 0.25*pi;
  phi = ntwists*0.5*ang-phioff;

  sphi = sin(phi);
  cphi = cos(phi);

  for j=1:N2+1

   % distance of a node from the centerline
   % for a certain i

   dfc1 = pp1(i,j)-pcl1(i);
   dfc2 = pp2(i,j)-pcl2(i);
   dfc3 = pp3(i,j)-pcl3(i);

   R1 = [A*A A*B A*C;
         B*A B*B B*C;
         C*A C*B C*C];

   R2 = [0 -C  B;
         C  0 -A;
        -B  A  0];

   P = cphi*eye(3) + (1.0-cphi)*R1 + sphi*R2;

% distance from centerline

   dfc = P*[dfc1; dfc2; dfc3];

   pm1(i,j) = pcl1(i) + dfc(1);
   pm2(i,j) = pcl2(i) + dfc(2);
   pm3(i,j) = pcl3(i) + dfc(3);

  end

 end

%---
% plot
%---

 figure(1)
 hold on
 axis equal
 fc = 1.2;
 axis([-fc*radius,fc*radius,-fc*radius,fc*radius,-fc*radius,fc*radius])
 axis off
 mesh(pp1,pp2,pp3,ppc)
%surf(pp1,pp2,pp3,ppc)
%plot3(1.01*pcl1,1.01*pcl2,1.01*pcl3,'k','linewidth',3)
 view(180,-44)
 view(136,16)

 figure(2)
 hold on
 axis equal
 fc = 1.5;
 axis([-fc*radius,fc*radius,-fc*radius,fc*radius,-fc*radius,fc*radius])
 axis off
 mesh(pm1,pm2,pm3,ppc)
%surf(pm1,pm2,pm3,ppc)
 view(180,-44)
 view(160,22)

%---
% perimeter and width distributions
%---

for j=1:N2+1
 perimeter(j) = 0.0;
 for i=1:N1
  perimeter(j) = perimeter(j) ...
  + sqrt((pp1(i+1,j)-pp1(i,j))^2  ...
  +      (pp2(i+1,j)-pp2(i,j))^2  ...
  +      (pp3(i+1,j)-pp3(i,j))^2);
 end
end

perimeter'
N1*a1

for i=1:N1
 width(i) = 0.0;
 for j=1:N2
 width(i) = width(i) ...
  + sqrt((pp1(i,j+1)-pp1(i,j))^2  ...
  +      (pp2(i,j+1)-pp2(i,j))^2  ...
  +      (pp3(i,j+1)-pp3(i,j))^2);
 end
end

width'
N2*a2
