clear all
close all

%========================
% generate a Mobius strip
% by a transformation
%========================

N1 = 12*4; % number of links along the strip
N2 = 2*4; % number of links across the strip

a1 = 2.0; % link length along the strip
a2 = 1.0; % link length  across the strip

%---
% prepare
%---

L = N1*a1;  % nominal strip length
W = N2*a2;  % nominal strip width

ushift = 0.18771; % arbitrary
ushift = 0.00000; % arbitrary
vshift = 0.5; 

%---
% transform
%---

for j=1:N2+1

 v = (j-1)/N2-vshift;

 for i=1:N1+1

  u = 2*pi*(i-1-ushift)/N1-pi;
  tmp = 1.0+0.5*v*cos(0.5*u);
  px(i,j) = tmp*cos(u);
  py(i,j) = tmp*sin(u);
  pz(i,j) = 0.5*v*sin(0.5*u);
  pc(i,j) = pz(i,j);   % color
  px(i,j) = L/(2*pi)*px(i,j);
  py(i,j) = L/(2*pi)*py(i,j);
  pz(i,j) = 2*W*pz(i,j);

 end

end

%---
% plot
%---

 figure(1)
 hold on
 axis equal
 fc = 0.2;
 fcz = 0.5;
 axis([-fc*L,fc*L,-fc*L,fc*L,-fcz*W,fcz*W])
 mesh(px,py,pz,pc)
%surf(px,py,pz,pc)
 xlabel('x','fontsize',15)
 ylabel('y','fontsize',15)
 zlabel('z','fontsize',15)
 set(gca,'fontsize',15)
 view(45,45)
 axis off

%---
% confirm perimeter
%---

for j=1:N2+1

 perimeter(j) = 0.0;

 for i=1:N1
  perimeter(j) = perimeter(j) ...
  + sqrt((px(i+1,j)-px(i,j))^2  ...
  +      (py(i+1,j)-py(i,j))^2  ...
  +      (pz(i+1,j)-pz(i,j))^2);
 end
end

perimeter'
L

%---
% confirm width
%---

for i=1:N1

 width(i) = 0.0;

 for j=1:N2

 width(i) = width(i) ...
  + sqrt((px(i,j+1)-px(i,j))^2  ...
  +      (py(i,j+1)-py(i,j))^2  ...
  +      (pz(i,j+1)-pz(i,j))^2);
 end

end
width'
W
