clear all
close all

%==================
% Graph Laplacian matrix
% of the Mobius network
%==================

N1 = 3;
N2 = 3;

%---
% initialize
%---

for i=1:N1
 for j=1:N1
  U(i,j) = 0.0;
  J(i,j) = 0.0;
 end
end

for i=1:N2+1
 for j=1:N2+1
  V(i,j) = 0.0;
 end
end

for i=1:N2+1
 for j=1:N2+1
  K(i,j) = 0.0;
 end
end

%---
% unit backdiagonal
%---

for i=1:N2+1
  K(i,N2+2-i) = 1.0;
end

%---
% tridiagonal
% in the first direction
%---

U(1,1) =  2;
U(1,2) = -1;

U(N1,N1) = 2;
U(N1,N1-1) = -1; 

for i=2:N1-1
 U(i,i) = 2;
 U(i,i-1) = -1;
 U(i,i+1) = -1;
end

%---
% tridiagonal
% in the second direction
%---

V(1,1) = 1;
V(1,2) = -1;
V(N2+1,N2+1) = 1;
V(N2+1,N2) = -1; 

for i=2:N2
 V(i,i) = 2;
 V(i,i-1) = -1;
 V(i,i+1) = -1;
end

%---
% matrix J
%---

J(1,N1) = 1.0;
J(N1,1) = 1.0;

%---
% Laplacian
%---

Lapl = kron(eye(N2+1),U) - kron(K,J) + kron(V,eye(N1));
Lapl

% doubly periodic

LaplPD = kron(eye(N2+1),U) - kron(eye(N2+1),J) + kron(V,eye(N1));
LaplPD

%---
% eigenvalues
%---

egvl = eig(Lapl);

%---
% eigenvalues analytically
%---

Ic = 0;

for n1=1:N1
 for n2=1:N2+1
  gamma = ( 1+(-1)^n2 )/4.0;
  alpha = ( n1-1+gamma )*2.0*pi/N1;
  beta  = (n2-1)*pi/(N2+1);
  Ic = Ic+1;
  lmd(Ic) = 4*sin(0.5*alpha)^2 + 4*sin(0.5*beta)^2;
  lambda(n1,n2) = lmd(Ic);
 end
end

lmd = sort(lmd);

[egvl lmd']
