clear all
close all

%=================================
% Solution of the Poisson equation
% in a rectangle confined between
%
% -a < x < a and -b < y < b
%
% with the doubly periodic condition
%=================================

Nx = 3;
Ny = 3;

Nx = 16;
Ny = 14;

a = 1.0;
b = 0.5;

%---
% prepare
%---

Dx = 2.0*a/Nx;
Dy = 2.0*b/Ny;

beta = Dx^2/Dy^2;

%---
% grid
%---

for i=1:Nx+1
 x(i) = -a + (i-1)*Dx;
end

for i=1:Ny+1
 y(i) = -b + (i-1)*Dy;
end

%---
% specify the source (typical)
%---

for j=1:Ny
 for i=1:Nx
  source(i,j) = 50.0*x(i)*y(j);
 end
end

%---
% circulant tridiagonal in x
%---

U(1,1) =-2; U(1,2) = 1; U(1,Nx) = 1;
U(Nx,1) = 1; U(Nx,Nx) =-2; U(Nx,Nx-1) = 1;

for i=2:Nx-1
 U(i,i)   =-2;
 U(i,i-1) = 1;
 U(i,i+1) = 1;
end

%---
% circulant tridiagonal in y
%---

V(1,1) =-2; V(1,2) = 1; V(1,Ny) = 1;
V(Ny,1) = 1; V(Ny,Ny) =-2; V(Ny,Ny-1) = 1;

for i=2:Ny-1
 V(i,i)  = -2;
 V(i,i-1) = 1;
 V(i,i+1) = 1;
end

A = kron(eye(Ny),U) + beta*kron(V,eye(Nx));
%A

%---
% system size
%---

Nsys = Nx*Ny;

%---
% right-hand side
%---

Ic = 0;
sumrhs = 0;

for j=1:Ny
 for i=1:Nx
  Ic = Ic+1;
  rhs(Ic) = -source(i,j)*Dx^2;
  sumrhs = sumrhs + rhs(Ic);
 end
end

shift = sumrhs/Nsys;

for i=1:Nsys
 rhsn(i) = rhs(i)-shift;
end

%---
% solve
%---

% sol = rhs/A';

Areduced   = A(1:Nsys-1,1:Nsys-1);
rhsreduced = rhsn(1:Nsys-1);
sol = rhsreduced/Areduced';
sol(Nsys) = 0.0;
residual = A*sol'-rhsn';

%---
% distribute the solution
%---

Ic = 0;

for j=1:Ny
 for i=1:Nx
  Ic = Ic+1;
  f(i,j) = sol(Ic);
 end
end

for j=1:Ny
 f(Nx+1,j) = f(1,j);
end

for i=1:Nx
 f(i,Ny+1) = f(i,1);
end

f(Nx+1,Ny+1) = f(1);

%---
% plot
%---

figure(1)
%mesh(x,y,f')
surf(x,y,f')
box on
axis equal
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
zlabel('f','fontsize',15)
set(gca,'fontsize',15)
view(38,15)
