clear all
close all

%==============================
% coefficient matrix
% through matrix tensor products
% for PPDD boundary conditions
%==============================

Nx = 3;
Ny = 3;

%---
% nearly tridiagonal in x
% of size Nx x Nx
%---

U(1,1) = -2;
U(1,2) = 1;
U(1,Nx) = 1;
U(Nx,1) = 1;
U(Nx,Nx) = -2;
U(Nx,Nx-1) = 1;

for i=2:Nx-1
 U(i,i) = -2;
 U(i,i-1) = 1;
 U(i,i+1) = 1;
end

%---
% tridiagonal in y
%---

V(1,1) = -2;
V(1,2) = 2;          % notice the 2
V(Ny+1,Ny+1) = -2;
V(Ny+1,Ny) = 2;      % notice the 2

for i=2:Ny
 V(i,i) = -2;
 V(i,i-1) = 1;
 V(i,i+1) = 1;
end

beta = 3.0; % arbitrary

A = kron(eye(Ny+1),U) + beta*kron(V,eye(Nx));
A
