clear all
close all

%=====================================
% coefficient finite-difference matrix
% through matrix tensor products
% for DNDD boundary conditions
%=====================================

Nx = 3;
Ny = 4;

%---
% tridiagonal in x
% (DN)
%---

U(1,1) = -2;
U(1,2) = 1;
U(Nx,Nx) = -2;  % Dirichlet condition
U(Nx,Nx-1) = 2; % Neumann condition

for i=2:Nx-1
 U(i,i) = -2;
 U(i,i-1) = 1;
 U(i,i+1) = 1;
end

%---
% tridiagonal in y
%---

V(1,1) = -2;
V(1,2) = 1;
V(Ny-1,Ny-1) = -2;
V(Ny-1,Ny-2) = 1;

for i=2:Ny-2
 V(i,i) = -2;
 V(i,i-1) = 1;
 V(i,i+1) = 1;
end

beta = 3.0;  % arbitrary

A = kron(eye(Ny-1),U) + beta*kron(V,eye(Nx));
A
