clear all
close all

%==================
% Laplacian matrix
% of an isolated square network
%==================

N1 = 3;
N2 = 2;

%---
% tridiagonal in x
%---

U(1,1) = 1; U(1,2) = -1;
U(N1+1,N1) = -1; U(N1+1,N1+1) = 1;

for i=2:N1
 U(i,i) = 2;
 U(i,i-1) = -1;
 U(i,i+1) = -1;
end

%---
% tridiagonal in y
%---

V(1,1) = 1; V(1,2) = -1;
V(N2+1,N2) = -1; V(N2+1,N2+1) = 1;

for i=2:N2
 V(i,i) = 2;
 V(i,i-1) = -1;
 V(i,i+1) = -1;
end

Lapl = kron(eye(N2+1),U) + kron(V,eye(N1+1));
Lapl

%---
% eigenvalues
%---

for i=1:N1+1
 alpha = (i-1)*pi/(N1+1);
 eigva(i) = 4*sin(0.5*alpha)^2;
end
eig(U)
eigva'
