clear all
close all

%==================
% Laplacian matrix
% of an isolated square network
% periodic in the first direction
%==================

N1 = 3;
N2 = 3;

%---
% periodic in x
%---

U(1,1) = 2; U(1,2) = -1; U(1,N1) = -1;
U(N1,1) = -1; U(N1,N1-1) = -1; U(N1,N1) = 2;

for i=2:N1-1
 U(i,i) = 2;
 U(i,i-1) = -1;
 U(i,i+1) = -1;
end

%---
% periodic in y
%---

V(1,1) = 2; V(1,2) = -1; V(1,N2) = -1;
V(N2,1) = -1; V(N2,N2-1) = -1; V(N2,N2) = 2;

for i=2:N2-1
 V(i,i) = 2;
 V(i,i-1) = -1;
 V(i,i+1) = -1;
end

%---
% Laplacian
%---

Lapl = kron(eye(N2),U) + kron(V,eye(N1));
Lapl
