clear all
close all

%=============================
% Solution of Poisson equation
% in a rectangular duct
% inside -a<x<a and -b<y<b
% driven by the motion of the upper wall
% with the slip boundary condition
% along all walls
%=============================

a = 1.0;
b = 1.0;
b = 0.5;

Ny = 2*16;
Nz = 2*16;

slipltop = 0.5;
slipltop = 0.01;
slipltop = 0.1;

sliplwall = 0.1;
sliplwall = 0.001;

Vtop = 1.0;

%---
% prepare
%---

Dy = 2.0*a/Ny;
Dz = 2.0*b/Nz;

beta = Dy^2/Dz^2;

%---
% grid
%---

for i=1:Ny+1
 x(i) = -a + (i-1)*Dy;
end

for i=1:Nz+1
 y(i) = -b + (i-1)*Dz;
end

%---
% tridiagonal in y
%---

slpwall = 2.0*Dy/sliplwall;

U(1,1) = -2-slpwall;
U(1,2) = 2;
U(Ny+1,Ny+1) =-2-slpwall;
U(Ny+1,Ny)   = 2;

for i=2:Ny
 U(i,i)   =-2;
 U(i,i-1) = 1;
 U(i,i+1) = 1;
end

%---
% tridiagonal in z
%---

slptop = 2.0*Dz/slipltop;

V(1,1) = -2-slpwall;
V(1,2) =  2;
V(Nz+1,Nz+1) =-2-slptop;
V(Nz+1,Nz)   = 2;

for i=2:Nz
 V(i,i) = -2;
 V(i,i-1) = 1;
 V(i,i+1) = 1;
end

%---
% coefficient matrix
%---

A = kron(eye(Nz+1),U) + beta*kron(V,eye(Ny+1));
%A

%---
% system size
%---

Nsys = (Ny+1)*(Nz+1);

%---
% right-hand side
%---

for i=1:Nsys
 rhs(i) = 0.0;
end

for i=1:Ny+1
 Vtop = 1.0-x(i)^2/a^2;
 Vtop = 1.0;
 rhs(Nsys+1-i) = -2.0*beta*Dz*Vtop/slipltop;
end

%---
% solve
%---

SOL = rhs/A';

%---
% distribute
%---

Ic = 0;

for j=1:Nz+1
 for i=1:Ny+1
  Ic = Ic+1;
  f(i,j) = SOL(Ic);
 end
end

%---
% plot
%---

figure(1)
surf(x,y,f')
box on
axis equal
axis([-a a -b b 0 1])
xlabel('y/a','fontsize',15)
ylabel('z/a','fontsize',15)
zlabel('u/V','fontsize',15)
set(gca,'fontsize',15)
view(-33, 22)
