clear all
close all

%------------------------------------
% random walkers to nearest neighbors
%------------------------------------

Dt = 1.0;    % time step
Dx = 1.0;    % spatial step

%---
% number of walkers (arbitrary)
% walkers will be assigned
% in 2*nws initial columns
%---

nws = 1; 

nwc = 32*128;     % walkers per column (arbitrary)
nwalker = 2*nws*nwc;

%---
% define bins
% and initial population of bins
%---

nbin = 50;  % arbitrary
ishift = nbin+1;

for i=-nbin:nbin
 binx(i+ishift) = (i-0.5)*Dx;  % x position of bin
 binp(i+ishift) = 0;     % bin population
end

%---
% assign the initial x-position of the walkers
% in 2*nw+1 columns
% and compute the initial bin population
%---

%Ic = 0; % walker counter
%
%for i=1:nwc
%  for p =-nws:nws
%   Ic = Ic+1;
%   xwalker(Ic) = p;
%   binp(ishift+p) = binp(ishift+p)+1;
%  end
%end

Ic = 0; % walker counter

for i=1:nwc
  for k =-nws+1:nws
   Ic = Ic+1;
   xwalker(Ic) = k;
   binp(ishift+k) = binp(ishift+k)+1;
  end
end

%---
% plot the initial bin population
%---

figure(1)
hold on
xlabel('i','fontsize',15)
ylabel('population','fontsize',15)
set(gca,'fontsize',15)
box on
plot(binx,binp/nwalker,'ko')
axis([-20 20 0 1])

%---
% simulation
%---

nsteps = 2*32;
time = 0.0;

%---
for n=1:nsteps
%---

 for i=1:nwalker
  j = xwalker(i);        % current x position of walker
  walk = 1;
  if(rand>0.5)           % fly to the left or right
   walk = -1;
  end
  % update the x position of walker:
  xwalker(i) = j + walk;
  % update the bin population:
  binp(j+ishift) = binp(j+ishift) - 1; 
  binp(j+ishift+walk) = binp(j+ishift+walk) + 1;
 end

 time = time + Dt;

%---
% Green's function 
%---

 kappa = 0.5*Dx^2/Dt;
 var = 2.0*kappa*time;
 sdv = sqrt(var);

 for i=-nbin:nbin
   xx = binx(i+ishift);
   binG(i+ishift) = 1.0/(sqrt(2*pi)*sdv)*exp(-0.5*xx^2/var);
 end

 clf
 hold on
 xlabel('i','fontsize',15)
 ylabel('population','fontsize',15)
 set(gca,'fontsize',15)
 box on
 plot(binx,binp/nwalker,'k.')
 plot(binx,binG,'r-')
 pause(0.1)

end
