function [T1,T2,Phi1,Phi2] = slabs_solve ...
 ...
        (T1,alpha1,T1w,T1_phan,N1 ...
        ,T2,alpha2,T2w,T2_phan,N2 ...
        ,beta,lambda,lambdac)

%---
% Thomas coefficients
%---

for i=1:N1
 atr1(i) = 1.0+2.0*alpha1;
 btr1(i) = -alpha1;
 ctr1(i) = -alpha1;
end

for i=1:N2
 atr2(i) = 1.0+2.0*alpha2;
 btr2(i) = -alpha2;
 ctr2(i) = -alpha2;
end

%---
% right-hand sides
%---

for i=1:N1
 s1(i) = T1(i+1);
end

s1(1)  = s1(1)  + alpha1*T1w;
s1(N1) = s1(N1) + alpha1*T1_phan;

for i=1:N2
 s2(i) = T2(i);
end

s2(1)  = s2(1)  + alpha2*T2_phan;
s2(N2) = s2(N2) + alpha2*T2w;

%---
% solutions by the Thomas algorithm
%---

sol1 = thomas (N1,atr1,btr1,ctr1,s1);

for i=1:N1
 T1(i+1) = sol1(i);
end

sol2 = thomas (N2,atr2,btr2,ctr2,s2);

for i=1:N2
 T2(i) = sol2(i);
end

%---
% compute Phi(1) and Phi(2)
%---

DTI = T1(N1+1)-T2(1);
fc = 2.0*DTI/N1;

Phi1 = T1_phan - T1(N1) + lambdac*fc;
Phi2 = T2_phan - T2(2)  - beta*lambdac/lambda*fc;

%---
% done
%---

return
