clear all
close all

%================================
% temperature evolution in a layer
% by the explicit FTCS method
%================================

N = 2*32;

h = 1.0;
kappa = 1.0;

T1 = 0.0;
T2 = 1.0;

nstep = 700;  % number of steps

al = 0.40;  % alpha
al  = 0.495;  % alpha
al  = 0.505;  % alpha

nstep = 2*128;  % number of steps

mstep = 32;  % number of steps for plotting

%---
% prepare
%---

Dy = h/N;
Dt = al*Dy*Dy/kappa;

%---
% plotting
%---

figure(2)
axis([0 1.0 0 h])
xlabel('T','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
hold on
box on

%---
% grid and initial condition
%---

for i=1:N+1
 y(i) = (i-1)*Dy;
 T(i) = 0.0;
end

T(1) = T1;
T(N+1) = T2;

t = 0.0;
istep = mstep;

%---
% time stepping
%---

for step=1:nstep

 Tnew(1) = T1;

 for i=2:N
  Tnew(i) = al*T(i-1) + (1.0-2.0*al)*T(i) + al*T(i+1);
 end

 t = t+Dt;
 Tnew(N+1) = T2;
 T = Tnew;

 if(step==1)
  figure(1)
  Handle1 = plot(T,y,'.k-');
  set(Handle1, 'erasemode', 'xor');
  set(gca,'fontsize',15)
  axis([0 1.0 0 h])
  xlabel('T','fontsize',15)
  ylabel('y','fontsize',15)
 else
  figure(1)
  set(Handle1,'XData',T,'YData',y);
  hold on
  pause(0.02)
  drawnow
 end

  if(istep==mstep)
   figure(2)
   plot(T,y,'.k-');
   istep = 0;
  end

  istep = istep+1;

end
%---
