clear all
close all

%================================
% temperature evolution in a layer
% by the implicit BTCS method
%================================

N = 2*32;

h = 1.0;
kappa = 1.0;

T1 = 0.0;
T2  = 1.0;

al = 0.40;  % alpha
al = 0.51;  % alpha
al =10.00;  % alpha
al = 1.00;  % alpha

nstep = 8*128;  % number of steps

mstep = 32;  % number of steps for plotting

%---
% prepare
%---

Dy = h/N;
Dt = al*Dy*Dy/kappa;

%---
% grid and initial condition
%---

for i=1:N+1
 y(i) = (i-1)*Dy;
 T(i) = 0.0;
end

T(1) = T1;
T(N+1) = T2;

%---
% tridiagonal projection matrix
%---

for i=1:N-1
 atr(i) = 1.0+2*al;
 btr(i) = -al;
 ctr(i) = -al;
end

%---
% ploting
%---

figure(2)
axis([0 1.0 0 h])
xlabel('T','fontsize',15)
ylabel('y','fontsize',15)
set(gca,'fontsize',15)
hold on
box on

%---
% time stepping
%---

t = 0.0;
istep = mstep;

%---

for step=1:nstep

 for i=1:N-1    % right-hand side
  s(i) = T(i+1);
 end

 T(1)  = T1;
 T(N+1) = T2;
 s(1)   =s(1)  + al*T(1);
 s(N-1) =s(N-1)+ al*T(N+1);

 sol = thomas (N-1,atr,btr,ctr,s);

 for i=2:N
  T(i) = sol(i-1);
 end

 t=t+Dt;

 if(step==1)
   figure(1)
   Handle1 = plot(T,y,'ko-');
   set(Handle1, 'erasemode', 'xor');
   set(gca,'fontsize',15)
   axis([min(T1,T2) max(T1,T2) 0 h])
   xlabel('T','fontsize',15)
   ylabel('y','fontsize',15)
 else
   figure(1)
   set(Handle1,'XData',T,'YData',y);
   pause(0.2)
   drawnow
 end

  if(istep==mstep)
   figure(2)
   plot(T,y,'.k-');
   istep = 0;
  end

  istep = istep+1;

end
%---
