function sarray = shell_ode ...
  ...
   (a,c ...
   ,kappa0,Dp ...
   ,kappaB,Nstp ...
   ,Dl)

%---
% prepare
%---

 Dlh = 0.5*Dl;

%---
% initial condition
%---

  x(1) = kappa0;
  x(2) = 0.0;
  x(3) = 0.0;
  x(4) = 0.0;
  x(5) = 1.0;
  x(6) = 0.0;
  x(7) = 0.0;

  for j=1:7
    sarray(j,1) = x(j);
  end

%---
% integrate
%---

 for i=1:Nstp

      al = (i-1.0)*Dl;

      for j=1:7
       xsave(j) = x(j);
      end

      g0 = shell_vel (a,c,Dp,kappaB,x);

      for j=1:7
        x(j) = xsave(j) + Dlh*g0(j);
      end

      g1 = shell_vel (a,c,Dp,kappaB,x);

      for j=1:7
        x(j) = xsave(j) + Dlh*g1(j);
      end

      g2 = shell_vel (a,c,Dp,kappaB,x);

      for j=1:7
        x(j) = xsave(j) + Dl*g2(j);
      end

      g3 = shell_vel (a,c,Dp,kappaB,x);

      for j=1:7
        vel = (g0(j) + 2.0*g1(j) + 2.0*g2(j) + g3(j))/6.0;
        x(j) = xsave(j) + Dl*vel;
      end

      for j=1:7
       sarray(j,i+1) = x(j);
      end

 end

%---
% done
%---

return
