clear all
close all

%-------------------------
% particle solution of 
% the convection equqtion
%-------------------------

N  = 2*2*2*64; % number of particles

a  =-10;
b  = 10;

Dt = 0.00010; % time step

%---
% prepare
%---

Dx = (b-a)/N;

%---
% initial position and velocity
%---

for i=1:N
 x(i) = a+(i-0.5)*Dx;

 vinit(i) = tanh(x(i));
 vinit(i) = 1.0;
 vinit(i) = exp(-x(i)^2);

 v(i) = vinit(i); % Burgers

end

time = 0.0;

%-----
for istep=1:30000
%-----

 for i=1:N
  x = x + Dt*v;
 end

 time = time + Dt;

 if(istep==1)
  Handle1 = plot(x,vinit,'ko-');
  set(Handle1, 'erasemode','xor');
  axis([-5 5 -0.0 1.2])
% axis([-2 2 -1.2 1.2])
  xlabel('x','fontsize',15)
  ylabel('v','fontsize',15)
  set(gca,'fontsize',15)
 else
  set(Handle1,'XData',x,'YData',vinit);
  pause(0.2)
  drawnow
 end

%-----
end
%-----

