close all
clear all

%============================================
% Evolution of
% unidirectional two-layer flow in a channel
% computed by the explicit ftcs method
%============================================

%---
% parameters
%---

h = 1.0;
h1 = 0.25;

N1 = 8;
N2 = 16;

mu1 = 10.0;
mu2 = 1.0;

rho1 =1.5;
rho2 = 1.0;

dpdx= -16.0;
gx = 0.0;

V1 = 0.1;
V2 = 0.3;

alpha = 0.40;
alpha = 0.52;

nstep = 1000;
mstep = 50;

nstep = 500;
mstep = 50;

%---
% prepare
%---

h2 = h-h1;
Dy1 = h1/N1;
Dy2 = h2/N2;

lambda = mu2/mu1;
delta = rho2/rho1;
gamma = lambda/delta;
beta = Dy2/Dy1;

tmp = gamma+beta*lambda;
a1 = (gamma-beta*lambda)/tmp;
a2 = 2.0*lambda*(beta*beta-gamma)/(beta*tmp);
a3 = 2.0*gamma*lambda/(beta*tmp);
a4 = lambda*Dy2*Dy2*(1.0-1.0/delta)/(beta*mu1*tmp);

Dt1 = rho1*alpha*Dy1*Dy1/mu1;
Dt2 = rho2*alpha*Dy2*Dy2/mu2;
Dt = min(Dt1,Dt2);

al1 = Dt*mu1/(Dy1*Dy1*rho1);
al2 = Dt*mu2/(Dy2*Dy2*rho2);

%---
% ploting
%---

figure(2)
set(gca,'fontsize',15)
axis([0 1.0 0 h])
xlabel('u','fontsize',15)
ylabel('y','fontsize',15)
hold on
box on

%---
% initialize
%---

for i=1:N1+1
  u1(i) = 0.0;
  y1(i) = (i-1)*Dy1;
end

for i=1:N2+1
  u2(i) = 0.0;
  y2(i) = (i-1)*Dy2+h1;
end


t = 0.0;
istep = mstep;

%---
% time stepping
%---

for step=1:nstep

  u1(N1+2) = a1*u1(N1) + a2*u1(N1+1) + a3*u2(2) + a4*dpdx;

  unew1(1) = V1;

  for i=2:N1+1
   unew1(i) = al1*u1(i+1)+(1-2*al1)*u1(i)+al1*u1(i-1)...
       +Dt*(-dpdx/rho1+gx);
  end

  unew2(1) = unew1(N1+1);

  for i=2:N2
   unew2(i) = al2*u2(i+1)+(1-2*al2)*u2(i)+al2*u2(i-1)...
       +Dt*(-dpdx/rho2+gx);
  end

  unew2(N2+1) = V2;

  u1 = unew1;
  u2 = unew2;

%---
% animation
%---

 if(step==1)
  figure(1)
  handle1 = plot(u1,y1,'ko-',u2,y2,'ko-');
  set(gca,'fontsize',15)
  axis([0 1.0 0 h])
  xlabel('u','fontsize',15)
  ylabel('y','fontsize',15)
 else
  figure(1)
  set(handle1,'XData',[u1, u2],'YData',[y1, y2],'Marker','o')
  drawnow
  hold on
  plot([0, 1.0], [h1, h1],'k')
  pause(0.02)
 end

  if(istep==mstep)
   figure(2)
   plot(u1,y1,'k.-');
   plot(u2,y2,'k.-');
   istep = 0;
  end

  istep = istep+1;

%---
end % of time stepping
%---
