function [u1,u2,Phi1,Phi2] = layers_btcs_solve...
 ...
        (u1,alpha1,u1w,u1_phan,N1 ...
        ,u2,alpha2,u2w,u2_phan,N2 ...
        ,Dt,chi,rho1,rho2,gx ...
        ,beta,lambda ...
        ,a1,a2,a3,a4)

%---
% Thomas coefficients
%---

for i=1:N1
 atr1(i) = 1.0+2.0*alpha1;
 btr1(i) = -alpha1;
 ctr1(i) = -alpha1;
end

for i=1:N2
 atr2(i) = 1.0+2.0*alpha2;
 btr2(i) = -alpha2;
 ctr2(i) = -alpha2;
end

%---
% right-hand sides
%---

tmp1 = Dt*(chi+rho1*gx)/rho1;

for i=1:N1
 s1(i) = u1(i+1) + tmp1;
end

s1(1)  = s1(1)  + alpha1*u1w;
s1(N1) = s1(N1) + alpha1*u1_phan;

tmp2 = Dt*(chi+rho2*gx)/rho2;

for i=1:N2
 s2(i) = u2(i) + tmp2;
end

s2(1)  = s2(1)  + alpha2*u2_phan;
s2(N2) = s2(N2) + alpha2*u2w;

%---
% solutions by the Thomas algorithm
%---

sol1 = thomas (N1,atr1,btr1,ctr1,s1);

for i=1:N1
 u1(i+1) = sol1(i);
end

sol2 = thomas (N2,atr2,btr2,ctr2,s2);

for i=1:N2
 u2(i) = sol2(i);
end

%---
% compute Phi(1) and Phi(2)
%---

Phi1 = u1_phan - a1*u1(N1) - a2*u1(N1+1) - a3*u2(2) + a4*chi; 
Phi2 = u2_phan + beta/lambda*(u1_phan - u1(N1)) - u2(2);

%---
% done
%---

return
