clear all
close all

%---
% data
%---

chi = 1.0;
mu = 1.0;
a = 1.0; % initial radius
Pouter = 1.0;
pc = 0.0;
Dx = 0.15*a;
gamma = 1.0;
nsteps = 4*32;

alpha = 0.8;
beta = 0.01;

%---
% prepare
%---

L = 2*pi*a;
b = a;
Q = pi/4*chi/mu*a^4;

p0 = pc;

Dpc = Pouter-pc;
Dp0 = Pouter-p0;

p = p0;
Dp = Pouter-p;

x = 0.0;

fc = -4/pi * mu*Q;

%---
% for drawing cross-sections
%---

ndiv = 16;
Deta = 2*pi/ndiv;

for i=1:ndiv+1
 eta(i) = (i-1)*Deta;
 cseta(i) = cos(eta(i));
 sneta(i) = sin(eta(i));
end

%---
% integrate in x
%---

for ns=1:nsteps

 dpdx = fc/a^4 * (1+gamma^2)/gamma^3;

 x = x+Dx;
 p = p + dpdx*Dx;
 Dp = Pouter-p;
 E = ell_int(sqrt(1-gamma^2));
% [F,E] = ellipke(gamma^2);
 gamma = 1.0 - 0.5*sqrt(3)*sqrt(Dp/Dpc-1);
 gamma = 1.0 - alpha*tanh(beta*(Dp/Dpc-1));
 a = L/(4.0*E);
 b = a*gamma;

 if(gamma<0.01) break; end;

 plotx(ns) = x;
 plotgamma(ns) = gamma;

 for i=1:ndiv+1
  xprof(ns,i) = x;
  yprof(ns,i) = a*cseta(i);
  zprof(ns,i) = b*(sneta(i)-0.0*sneta(i)^4);
 end

%---
end % of integration
%---

nsteps = ns-1;

%---
% plot
%---

figure(1)
hold on
surf(xprof,yprof,zprof)
%for ns=1:nsteps
% plot3(xprof(ns,:),yprof(ns,:),zprof(ns,:),'k')
%end
%for i=1:ndiv
% plot3(xprof(:,i),yprof(:,i),zprof(:,i),'k')
%end
box on
axis equal
xlabel('x','fontsize',15)
ylabel('y','fontsize',15)
zlabel('z','fontsize',15)
set(gca,'fontsize',15)
view(30,42)

%---
% another plot
%---

figure(2)
hold on
plot(plotx, plotgamma,'-k')
xlabel('x','fontsize',15)
ylabel('b/a','fontsize',15)
set(gca,'fontsize',15)
%axis([0 1 0 1])
box
