  clear all
  close all

%===========
% Driver for one nonlinear equation
% using the second order Newton's method 
%
% Will compute 7 successive roots
%===========

 global slipl

%---
% parameters
%---

  Niter = 10;
  eps = 0.00001;
  italk = 0;

%---
% run
%---

  for n=1:7  % over roots

  for iloop=1:32 % over lambda

  if(iloop==1)
   slipl=0.00; 
  else
   slipl = slipl+0.05;
  end


% initial guesses are the zeros of J0

  if(iloop==1)
   if(n==1) x =  2.4048; end
   if(n==2) x =  5.5201; end
   if(n==3) x =  8.6537; end
   if(n==4) x = 11.7915; end
   if(n==5) x = 14.9309; end
   if(n==6) x = 18.0711; end
   if(n==7) x = 21.2116; end
  end

  [x,f,Iflag] = newton ...
     ...
    (Niter ...
    ,eps ...
    ,x ...
    ,italk ...
    );

   alpha(n,iloop) = x;
   plotslipl(iloop) = slipl;
   plotn(n) = n;

end % over roots

end % over lambda

alpha'

%---
% plot
%---

figure(1)
hold on
for n=1:7
  if(n==1)
   plot(plotslipl,alpha(n,:),'r-')
  elseif(n==2)
   plot(plotslipl,alpha(n,:),'b-')
  else
   plot(plotslipl,alpha(n,:),'k-')
  end
  legend('n=1','n=2');
end
set(gca,'fontsize',15)
xlabel('\lambda','fontsize',15)
ylabel('\alpha_n','fontsize',15)
axis([0 1.5 0 22])
box on

figure(2)
mesh(plotslipl,plotn,alpha);
%surf(plotslipl,plotn,alpha);
axis([0 1.5 0 10 0 25])
%axis equal
box on
xlabel('\lambda','fontsize',15)
ylabel('n','fontsize',15)
zlabel('\alpha_n','fontsize',15)
set(gca,'fontsize',15)
view(-32,32)

