  function [x,f,Iflag] = newton ...
     ...
    (Niter ...
    ,eps ...
    ,x ...
    ,italk ...
    )

%-----------------------------------
% Solve one nonlinear equation f(x) = 0
% by the second-order Newton method
%-----------------------------------

   tol = 0.0000001;

%---------------------
% start the iterations
%---------------------

    for i=1:Niter

       f  = newton_fun(x);
       x1 = x + eps;     % derivative by finite differences
       f1 = newton_fun(x1);
       Df = (f1-f)/eps;
       Dx = -f/Df;
       x  = x+Dx;

        if(italk==1)  
         format long
         disp([x,f])
         format short
        end

      iescape = 1;
      if(abs(Dx) > tol) iescape = 0; end

      if(iescape==1)
       Iflag = 0;
       f = newton_fun(x);
       return
      end

    end

%---
% done
%---

 return
