clear all
close all

%---
% graphs of bessel functions
%---

Nplt = 2*64;
xmax = 16.0
Dx = xmax/Nplt;

for i = 1:Nplt+1;
 x(i) = (i-1)Dx;
 y(i) = bessel(0, x(i));
 z(i) = bessel(1, x(i));
 w(i) = y(i)/(x(i)*z(i));
 v(i) = x(i)*z(i);
end

figure(1)
hold on
plot(x,y,'k')
plot(x,z,'k--')
plot(x,w,'k-.')
xlabel('z','fontsize',15)
ylabel('J_0(z),    J_1(z)','fontsize',15)
set(gca,'fontsize',15)
axis([0 16 -0.5 1])
box on


figure(2)
hold on
plot(x,y,'k-')
plot(x,v,'k--')
xlabel('z','fontsize',15)
ylabel('J_0(z),         z J_1(z)','fontsize',15)
%plot([0 16], [0,0], 'k')
set(gca,'fontsize',15)
axis([0 16 -2.0 2.0])
box on

