function u = tube_rec_slip_vel...
 ...
   (a ...
   ,b ...
   ,visc ...
   ,den ...
   ,gac ...
   ,chi ...
   ,beta ...
   ,slipl ...
   ,y ...
   ,z ...
   )

%================================================
% Steady flow through a tube with rectangular
% cross-section of size in -a < y < a, -b < z < b
% due to a pressure gradient or gravity
% with slip walls
%
% The origin is set at the tube center
%
% SYMBOLS:
% --------
%
% beta:  tube inclination angle
% gac:   magnitude of the acceleration of gravity
%================================================

%---------
% prepare
%--------

  as  = a^2;
  bs  = b^2;
  zs  = z^2;
  aob = a/b;

  pg_mod = chi + den*gac*sin(beta);  % modified pressure gradient

  area = 4.0*a*b;  % tube cross-sectional area

  lambda = slipl/b;

%---------
% linear approximation for Phi
%---------

  alpha1 = 0.5*pi*(1.0-lambda);

  arg1 = alpha1*y/b;
  arg2 = alpha1*aob;
  arg3 = alpha1*z/b;

  Phi = 1.0+2.0*lambda;  % linear approximation for Phi

  deno = cosh(arg2)+lambda*alpha1*sinh(arg2);
  tmp  = cosh(arg1)*cos(arg3)/deno;
  term = 32/pi^3 * Phi*tmp;

  u = 0.5*pg_mod*bs*(1 + 2*lambda - zs/bs - term)/visc;

%-----
% done
%-----

  return
