  clear all
  close all

%============================================
% Unidirectional flow in a rectangular tube
% with the slip boundary condition
%
% scan the slip coefficient lambda
% and prepare a plot
%============================================

 global slipl

%---
% parameters
%---

  Niter = 10;
  eps = 0.00001;
  italk = 0;

  nloop = 32;

%---
% run
%---

%---
  for n=1:7  % run over terms
%---

  norm = (n-0.5)*pi;

%---
  for iloop=1:nloop;  % run over lambda
%---

  if(iloop==1)
   slipl=0.00; 
  else
   slipl = slipl+0.05;
  end

% initial guesses are the zeros of J0

  if(iloop==1)
   x = (n-0.5)*pi;
  end

  [x,f,Iflag] = tube_rec_slip_newton ...
     ...
    (Niter ...
    ,eps ...
    ,x ...
    ,italk ...
    );

   alpha(n,iloop) = x;
   plotalpha(n,iloop) = x/norm;
   plotslipl(iloop) = slipl;
   plotn(n) = n;

  end % of loop over lambda

 end % of loop over n

%alpha'

%---
% plot
%---

figure(1)
hold on

for n=1:7
  if(n==1)
   plot(plotslipl,plotalpha(n,:),'r-')
  elseif(n==2)
   plot(plotslipl,plotalpha(n,:),'b-')
  else
   plot(plotslipl,plotalpha(n,:),'k-')
  end
  legend('n=1','n=2');
end

plot([0 0.5],[1 0.5],'--r') % asymptotics
set(gca,'fontsize',15)
xlabel('\lambda','fontsize',15)
ylabel('\alpha_n/\alpha_n^0','fontsize',15)
axis([0 1.5 0.4 1])
box on

figure(2)
mesh(plotslipl,plotn,plotalpha);
%surf(plotslipl,plotn,alpha);
axis([0 1.5 0 10 0.4 1])
%axis equal
box on
xlabel('\lambda','fontsize',15)
ylabel('n','fontsize',15)
zlabel('\alpha_n/\alpha_n^0','fontsize',15)
set(gca,'fontsize',15)
view(-32,32)

%---
% compute and plot the coefficient Phi
% associated with E_1
%
% intregration by the mid-point rule
%
% compare with the linear approximation
%---

Nmr = 8*64;
Dw = 1.0/Nmr;

for iloop=1:nloop

 al1 = alpha(1,iloop);
 lam =  plotslipl(iloop);

 al1A = 0.5*pi*(1.0-lam);

 int0 = 0.0;
 int1 = 0.0;
 int2 = 0.0;

 int0A = 0.0;
 int1A = 0.0;
 int2A = 0.0;

 for i=1:Nmr

  w = (i-0.5)*Dw;

  cs = cos(al1*w);
  int0 = int0 + cs;
  int1 = int1 + cs^2;
  int2 = int2 + (1.0+2.0*lam-w^2)*cs;

  csA = cos(al1A*w);
  int0A = int0A + csA;
  int1A = int1A + csA^2;
  int2A = int2A + (1.0+2.0*lam-w^2)*csA;

 end

 int0 = Dw*int0;
 int1 = Dw*int1;
 int2 = Dw*int2;

 int0A = Dw*int0A;
 int1A = Dw*int1A;
 int2A = Dw*int2A;

 PHI(iloop) = int2/int1;
 PHA(iloop) = int2A/int1A;

 plotPHI(iloop) = PHI(iloop) * pi^3/32;
 plotPHA(iloop) = PHA(iloop) * pi^3/32;
 plotPHB(iloop) = (1+3*lam)/(1+lam);
 plotPHC(iloop) = 1+2*lam;

 PHIBRUSH(iloop) = int0/int1;
 PHABRUSH(iloop) = int0A/int1A;

 plotPHIBRUSH(iloop) = PHIBRUSH(iloop) * pi/4;
 plotPHABRUSH(iloop) = PHABRUSH(iloop) * pi/4;

end

figure(3)
hold on
plot(plotslipl,plotPHI,'k-')
%plot(plotslipl,plotPHA,'r--')
%plot(plotslipl,plotPHB,'b-.')
plot(plotslipl,plotPHC,'r--')
set(gca,'fontsize',15)
xlabel('\lambda','fontsize',15)
ylabel('\Phi','fontsize',15)
axis([0 1.5 1 4])
box on

figure(33)
hold on
plot(plotslipl,plotPHIBRUSH,'k-')
plot(plotslipl,plotPHABRUSH,'r--')
set(gca,'fontsize',15)
xlabel('\lambda_p','fontsize',15)
ylabel('\Phi','fontsize',15)
axis([0 1.5 0.8 1])
box on

%---
% flow rate
%---

figure(4)
hold on
set(gca,'fontsize',15)
xlabel('\lambda','fontsize',15)
ylabel('Q/Q_0','fontsize',15)
plot([0, 1.0],[1,5],'--b')   % circle
plot([0, 1.0],[1,4],'--r')  % channel
box on
axis([ 0 1 1 5])


for iboa=1:1

 if(iboa==1) boa = 1; end
 if(iboa==2) boa = 0.75; end
 if(iboa==3) boa = 0.5; end
 if(iboa==4) boa = 0.2; end

 for iloop=1:nloop

  al1 = alpha(1,iloop);
  lam = plotslipl(iloop);
  Phi = PHI(iloop);

  den = cosh(al1/boa) + lam*al1*sinh(al1/boa);
  F(iloop) = 1.0+3*lam -48/pi^3*Phi*boa*sinh(al1/boa)*sin(al1)/(al1^2*den);

 end

 red = F(1);
 for i=1:nloop
  F(i) = F(i)/red;
 end

 if(iboa==1)
  plot(plotslipl,F,'ko-')
 else
  plot(plotslipl,F,'k-')
 end

end
