clear all
close all

%====================================
% velocity profile for
% unidirectional flow through a tube
% with rectangular cross-section
% in the presence of wall slip
%====================================

%---
% parameters
%---

a = 1.0;
b = 1.0;
b = 0.5;

visc = 1.0;
den = 1.0;
gac = 1.0;
chi = 1.0;
beta = 0.0*pi;

slipl = 0.0;
slipl = 0.5;
slipl = 0.2;
slipl = 0.5;
slipl = 0.1;

%---
% divisions for profile
%---

Ny = 32;
Nz = 16;

%---
% prepare
%---

Dy = 2*a/Ny;
Dz = 2*b/Nz;

%---
% run over grid nodes
%---

for j=1:Nz+1

  z = -b + Dz*(j-1);

  for i=1:Ny+1

  y = -a + Dy*(i-1);

  u = tube_rec_slip_vel...
  ...
        (a ...
        ,b ...
        ,visc ...
        ,den ...
        ,gac ...
        ,chi ...
        ,beta ...
        ,slipl ...
        ,y ...
        ,z ...
        );

   yplot(i,j) = y;
   zplot(i,j) = z;
   uplot(i,j) = u;

   end
end

%---
% plot
%---

figure(1)
%mesh(yplot/a,zplot/a,5.0*uplot)
surf(yplot/a,zplot/a,5.0*uplot)
xlabel('y/a','fontsize',13)
ylabel('z/a','fontsize',13)
zlabel('5*u_x','fontsize',13)
set(gca,'fontsize',13)
axis equal
box on
view(-33, 22)
