clear all
close all

%---
% plot the cotangent function
% and a straight line
%---

Iopt=0;

nplot=2*128;

for i=1:nplot
 x(i) = 0.01+3*pi*(i-1)/nplot;
 X = x(i);
 y(i) = cot(X);
 z(i) = 0.2*X;
end

figure(1)
hold on
plot(x,y,'k')
plot(x,z,'k--')
plot([0 8],[0,0],'k')
xlabel('x','fontsize',15)
ylabel('cot (x)','fontsize',15)
set(gca,'fontsize',15)
axis([0 8 -10 10])
box
