clear all
close all

%----------------------------
% Compute the flow rate
% for flow in a rectangular tube
% with the no-slip boundary condition
%
% Plot the flow rate for different
% summation levels
%--------------

a = 1.0;

b = 0.5;
b = 1.0;

%--------
% prepare
%--------

 aob = a/b;

 nloop = 9;
 maxsm = 0;

%---
 for iloop = 1:nloop
%---

  maxsm = maxsm+1;

  sm = 0.0;

  for n=1:maxsm

    alpha = (n-0.5)*pi;
    sm = sm + tanh(alpha*aob)/alpha^5;

  end

  F(iloop) = 1.0-6.0*sm/aob;

%---
 end
%---

%---
 for i=1:nloop-1
  plotF(i) = (F(i)-F(nloop))/F(nloop);
  plotF(i) = log10(plotF(i));
  plotn(i) = log10(i);
 end
%---

%---
% plot
%---

figure(1)
hold on
plot(plotn(1:nloop-1),plotF,'ko')
plot(plotn(1:nloop-1),plotF,'r--')
xlabel('log(N)','fontsize',15)
ylabel('log( (F-F_\infty)/F_\infty )','fontsize',15)
set(gca,'fontsize',15)
box on
