clear all
close all

%===================================
% Unidirectional flow through a tube
% with rectangular cross-section
%===================================

%---
% parameters
%---

a = 1.0;
b = 1.0;
b = 0.5;

visc = 1.0;
den = 1.0;
gac = 1.0;
chi = 1.0;
beta =0.0*pi;

maxsm = 1;
maxsm = 20;

%---
% divisions for profile
%---

Ny = 32;
Nz = 16;

%---
% prepare
%---

Dy = 2*a/Ny;
Dz = 2*b/Nz;

%---
% run over grid nodes
%---

for j=1:Nz+1

  z = -b + Dz*(j-1);

  for i=1:Ny+1

  y = -a + Dy*(i-1);

  [flow_rate,u_mean,u_max,u] = tube_rec ...
  ...
        (a ...
        ,b ...
        ,visc ...
        ,den ...
        ,gac ...
        ,chi ...
        ,beta ...
        ,maxsm ...
        ,y ...
        ,z ...
        );

   yplot(i,j) = y;
   zplot(i,j) = z;
   uplot(i,j) = u;

   end
end

%---
% plot
%---

figure(1)
mesh(yplot/a,zplot/a,5*uplot)
xlabel('y/a','fontsize',13)
ylabel('z/a','fontsize',13)
zlabel('5 u_x','fontsize',13)
set(gca,'fontsize',13)
axis equal
box on
view(-33, 22)

%---
% shear stress
%---

eps = 0.01;

for i=1:Ny+1

  y = -a + Dy*(i-1);

  [flow_rate,u_mean,u_max,uss(i)] = tube_rec ...
  ...
        (a ...
        ,b ...
        ,visc ...
        ,den ...
        ,gac ...
        ,chi ...
        ,beta ...
        ,maxsm ...
        ,y ...
        ,eps ...
        );
end

%---
% plot
%---

figure(2)
hold on
plot(yplot/a,uss/eps,'k')
xlabel('y/a','fontsize',15)
ylabel('\sigma_{xy}','fontsize',15)
set(gca,'fontsize',13)
axis([-1 1 0 12])
box on

