function f = newton2_fun(menu,x)

global alpha

%---
% function evaluation for Newton's method
%---

     q    = 2.0*alpha;
     k    = sin(q)/q;
     coshy = 0.5*(exp(x(2))+exp(-x(2)));
     sinhy = 0.5*(exp(x(2))-exp(-x(2)));

%-----------------------
      if(menu == 1)   % anti-symmetric Stokes flow
%-----------------------

      f(1) = sin(x(1))*coshy + k*x(1);
      f(2) = cos(x(1))*sinhy + k*x(2);

%-----------------------
      elseif(menu == 2) % symmetric Stokes flow
%-----------------------

      f(1) = sin(x(1))*coshy - k*x(1);
      f(2) = cos(x(1))*sinhy - k*x(2);

%-----------------------
      end
%-----------------------

     return
