clear all
close all


global alpha

%------------------
% menu = 1: antisymmetric flow in a corner
%      = 2:     symmetric flow in a corner
%------------------

%---
% prepare
%---

   eps   = 0.001;  % epsilon for Newton iterations
   Niter = 100;      % maximum number of iterations
   Nint  = 128;      % number of intervals

   menu = 2;

   figure(1)
   hold on
   xlabel('\alpha/\pi','fontsize',15)
   ylabel('\lambda_R      \lambda_I       \xi      \eta','fontsize',15)
   set(gca,'fontsize',15)
   box on
   axis([0 1 0 6])

%---
% scan alpha
%---

   for iscan=1:3

   if(iscan==1)
      x(1)   = 7.1;    % initial guess for xi and eta (symmetric)
      x(2)   = 0.1;
      alphai = 78.0; %  alpha(initial) in degrees
      alphaf = 0.01;  % alpha(final) in degrees
   elseif(iscan==2)
      x(1)   = 7.1;    % initial guess for xi and eta (symmetric)
      x(2)   = 0.1;
      alphai = 78.0; %  alpha(initial) in degrees
      alphaf = 124.0;  % alpha(final) in degrees
   elseif(iscan==3)
      x(1)   = 3.2; 
      x(2)   = 0.0;
      alphai = 179.0;
      alphaf = 124.0;
   end

   alphaf = alphaf/180.0*pi;
   alphai = alphai/180.0*pi;

   dalpha = (alphaf-alphai)/Nint;

     for i=1:Nint+1

      alpha = alphai+(i-1.0)*dalpha;

      [x,f,Iflag] = newton2 ...
       ...
      (menu ...
      ,Niter ...
      ,eps ...
      ,x ...
      );

      lamR = x(1)/(2*alpha)+1.0;
      lamI = x(2)/(2*alpha);

      alphaplot(i) = alpha/pi;

      xiplot(i) = x(1);
      etplot(i) = x(2);
      lamRplot(i) = lamR;
      lamIplot(i) = lamI;

     end

     plot(alphaplot,lamRplot,'k')
     plot(alphaplot,lamIplot,'r')
     plot(alphaplot,xiplot,'k--')
     plot(alphaplot,etplot,'r--')

  end
