clear all
close all

%=========
% Unidirectional flow 
% in a two-dimensional brush
%=========

global lamw

%---
% parameters
%---

a = 1.0;
b = 2.0;
V = 1;

lamw = 0.1;
lamw = 0;

maxsm = 16;
maxsm = 1;
maxsm = 32;
maxsm = 64;

%---
% divisions for profile
%---

Ny = 32;
Nz = 16;

%---
% prepare
%---

Dy = 2*a/Ny;
Dz =   b/Nz;

%---
% run over grid nodes
%---

for j=1:Nz+1

  z = Dz*(j-1);

  for i=1:Ny+1

  y = -a + Dy*(i-1);

  [flow_rate,u] = chan_brush ...
  ...
        (a ...
        ,V ...
        ,maxsm ...
        ,y ...
        ,z ...
        );

   yplot(i,j) = y;
   zplot(i,j) = z;
   uplot(i,j) = u;

   end
end

%---
% plot
%---

figure(1)
mesh(yplot/a,uplot,zplot/a)
xlabel('y/a','fontsize',13)
ylabel('z/a','fontsize',13)
zlabel('u_x/V','fontsize',13)
set(gca,'fontsize',13)
axis equal
box on
view(133, 20)
