      program chan_brush_dr

c========================================
c FDLIB
c
c Copyright by C. Pozrikidis, 1999
c All rights reserved.
c
c This program is to be used only under the
c stipulations of the licensing agreement
c========================================

c--------------------------------------
c Steady flow through a semi-infinite rectangular
c channel bounded by a moving bottom wall,
c modeling the unit cells of the Taylor brush.
c
c The origin is set at the mid-point of a channel.
c
c Formulae are given by Pozrikidis (1997, p. 190)
c
c Symbols:
c --------
c
c V:    velocity of the brush 
c Max:  truncation limit for infinite sum
c--------------------------------------

      Implicit Double Precision (a-h,o-z)

c----------
c constants
c----------

      pi = 3.14159 265358

c------------
c preferences
c------------

      open (1,file="chan_brush.dat",status="unknown")

       read (1,*) nprof
       read (1,*) a       ! y semi-side
       read (1,*) V       ! brush velocity
       read (1,*) Max     ! truncation limit

      close (1)

c--------
c prepare
c--------

      open (2,file="chan_brush.out",status="unknown")

      nprof1 = nprof+1

      as = a**2

c--------------------------
c prepare to draw a profile
c--------------------------

  98  Continue

      write (6,*)
      write (6,*) "Please enter the y coordinate for a profile"
      write (6,*)
      write (6,*) "It must lie between",-a," and ",a
      write (6,*)
      write (6,*) "Enter  99 to quit"
      write (6,*) "-----------------"
      write (6,*)
      read  (5,*) y

      if(y.eq.99) then
        Go to 99
      else if(y.lt.-a) then
        write (6,*) " Sorry; limits exceeded"
        Go to 98
      else if(y.gt.a) then
        write (6,*) " Sorry; limits exceeded"
        Go to 98
      end if
      
c--------
c profile
c--------

      zstep = 4.0*a/(nprof1-1.0)

      write (2,900) nprof1,y

      write (6,*) 
      write (6,900) nprof1,y
      write (6,*) 
      write (6,*) "    u_x,   z"
      write (6,*) 

      Do i=1,nprof1

       z = (i-1.0)*zstep

       call chan_brush
     +
     +    (a
     +    ,V
     +    ,Max
     +    ,y,z
     +    ,flow_rate
     +    ,u
     +    )

       write (2,900) i,u,z
       write (6,900) i,u,z

      End Do

      write (6,*)
      write (6,901) flow_rate
      write (6,*)

      Go to 98

c-----
c Done
c-----

  99  Continue

      write (2,900) null
      close (2)

 900  Format (1x,i3,4(1x,f10.5))
 901  Format ("Flow rate     = ",f15.10
     +       )

      stop
      end
