function [flow_rate,u] = chan_brush ...
 ...
   (a ...
   ,V ...
   ,maxsm ...
   ,y ...
   ,z ...
   )

%===========================================
% FDLIB
%
% Copyright by C. Pozrikidis, 1999
% All rights reserved
%
% This program is to be used only under the
% stipulations of the licensing agreement
%===========================================

%================================================
% Flow through a two-dimensional brush
%
% SYMBOLS:
% --------
%
% maxsm: truncation limit for infinite sum
%================================================

%--------------------------
% compute:
%
% (a) velocity at (y,z)
% (b) flow rate 
%--------------------------

  global lamw

  sumv = 0.0;     % velocity
  sumf = 0.0;     % flow rate

  sign = -1.0;

  for n=1:maxsm

    alpha = (n-0.5)*pi;
    argy = alpha*y/a;
    argz = alpha*z/a;
    fc = 1.0/(1.0+lamw*alpha);
    sumv = sumv + sign*fc*exp(-argz)*cos(argy)/alpha;
    sumf = sumf + 1.0*fc*/alpha^3;
    sign = -sign;

  end

%---
% velocity
%---

  u = V*(1.0 + 2.0*sumv);

%---
% flow rate
%---

  flow_rate = 4.0*V*a^2*sumf;

%-----
% done
%-----

  return
