      subroutine chan_brush
     +
     +  (a
     +  ,V
     +  ,maxsm
     +  ,y,z
     +  ,flow_rate
     +  ,u
     +  )

c==========================================
c FDLIB
c
c Copyright by C. Pozrikidis, 1999
c All rights reserved.
c
c This program is to be used only under the
c stipulations of the licensing agreement
c==========================================

c------------------------------------------------------
c Steady flow through a semi-infinite rectangular channel
c bounded by a moving bottom wall,
c modeling the unit cells of the Taylor brush
c
c The origin is set at the mid-point of a channel
c
c Formulae are given by Pozrikidis (1997, p. 190)
c
c SYMBOLS:
c --------
c
c V: velocity of the brush 
c
c maxsm:  truncation limit for infinite sum
c------------------------------------------------------

      Implicit Double Precision (a-h,o-z)

c----------
c constants
c----------

      pi = 3.14159 265358 D0

c---
c compute:
c
c (a) the velocity using formula (5.1.34)
c
c (b) the flow rate from formula (5.1.35)
c     of Pozrikidis (1997, p. 191)
c---

      sumv = 0.0D0
      sumf = 0.0D0

      sign =-1.0D0

      Do i=1,maxsm
        alpha = (i-0.5D0)*pi
        argy = alpha*y/a
        argz = alpha*z/a
        sumv = sumv + sign*exp(-argz)*cos(argy)/alpha
        sumf = sumf + 1.0/alpha**3
        sign = -sign
      End Do

c---
c velocity
c---

      u = V*(1.0+2.0*sumv)

c---
c flow rate
c---

      flow_rate = 4.0*V* a**2 *sumf

c-----
c done
c-----

      return
      end
