clear all
close all

%====================================
% Solve the boundary-value problem
% for the Blasius equation
%
% will solve the boundary-value problem
% with Newton iterations
%
% will solve an extended system of six ODEs 
%
% will use the internal function ode23
%====================================

%---
% initial guess
%----

 x0 = [0.0, 0.0, 0.0, 0.0, 0.0, 1.0];

 options = odeset('RelTol',1e-06,'AbsTol',1e-06);

%---
% iterate
%---

 etaspan = [0, 20];

 for iter=1:10

  [eta, x] = ode23(@blasius6A_fnc,etaspan,x0,options);

  NN = size(x);
  N  = NN(1);

  residual = x(N,2)-1.0;

  x0 = [0.0; ...
        0.0; ...
        x0(3)-residual/x(N,5);...
        0.0; ...
        0.0; ...
        1.0];

  if(abs(residual)<0.00000001) break; end

 end

%---
% converged value
%---

format long
x0(3)
format short

%---
% plot the solution
%---

figure(1)
hold on
plot(eta,x(:,2),'k-')
xlabel('\eta','fontsize',15)
ylabel('f','fontsize',15)
set(gca,'fontsize',15)
box

