clear all
close all

%====================================
% Solve the boundary-value problem
% for the Blasius equation
%
% will solve the boundary-value problem
% with Newton iterations
%
% will solve an extended system of six ODEs 
%====================================

Nstep = 4*64;
etamax = 20.0;

deta = etamax/Nstep;
deth = 0.5*deta;

%---
% initial guess
%---

x3init = 0.277;

%---
% iterate
%---

 for iter=1:10

   x(1) = 0.0;
   x(2) = 0.0;
   x(3) = x3init;
   x(4) = 0.0;
   x(5) = 0.0;
   x(6) = 1.0;

%---
% integrate the six ODEs
%---

  eta = 0.0;

  etaa(1) = eta;

  for j=1:6
    xall(j,1) = x(j);
  end

%---
  for i=1:Nstep
%---

   for j=1:6
    xsave(j) = x(j);
   end

   xp0 = blasius6_fnc(x);

   for j=1:6
    x(j) = xsave(j) + deth*xp0(j);
   end

   xp1 = blasius6_fnc(x);

   for j=1:6
    x(j) = xsave(j) + deth*xp1(j);
   end

   xp2 = blasius6_fnc(x);

   for j=1:6
    x(j) = xsave(j) + deta*xp2(j);
   end

   xp3 = blasius6_fnc(x);

   for j=1:6
     vel = (xp0(j)+2.0*xp1(j)+2.0*xp2(j)+xp3(j))/6.0;
     x(j) = xsave(j) + deta*vel;
   end

   eta = eta + deta;

   etaa(i+1) = eta;

   for j=1:6
    xall(j,i+1) = x(j);
   end

%---
  end
%---

  residual = x(2)-1.0;

  x3init = x3init-residual/x(5);...

  if(abs(residual)<0.00000001) break; end

%---
% end of iterations
%---

 end

%---
% converged value for x3(0)
%---

format long
[residual x3init]
format short

%---
% plot the solution
%---

figure(1)
hold on
plot(xall(1,:),etaa,'k--')
plot(xall(2,:),etaa,'r-')
plot(xall(3,:),etaa,'k-.')
ylabel('\eta','fontsize',15)
set(gca,'fontsize',15)
axis([0 2.0 0 8])
box on
